/*
 * Decompiled with CFR 0.152.
 */
package cpw.mods.fml.common;

import java.nio.ByteBuffer;
import java.security.MessageDigest;
import java.security.cert.Certificate;
import modules.ru.amaz1ng.core.common.utils.annotations.ObfuscationIgnore;

@ObfuscationIgnore
public class CertificateHelper {
    private static final String HEXES = "0123456789abcdef";

    public static String getFingerprint(Certificate certificate) {
        if (certificate == null) {
            return "NO VALID CERTIFICATE FOUND";
        }
        try {
            MessageDigest messageDigest = MessageDigest.getInstance("SHA-1");
            byte[] byArray = certificate.getEncoded();
            messageDigest.update(byArray);
            byte[] byArray2 = messageDigest.digest();
            return CertificateHelper.hexify(byArray2);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static String getFingerprint(ByteBuffer buffer) {
        try {
            MessageDigest messageDigest = MessageDigest.getInstance("SHA-1");
            messageDigest.update(buffer);
            byte[] byArray = messageDigest.digest();
            return CertificateHelper.hexify(byArray);
        }
        catch (Exception exception) {
            return null;
        }
    }

    private static String hexify(byte[] chksum) {
        StringBuilder stringBuilder = new StringBuilder(2 * chksum.length);
        for (byte by : chksum) {
            stringBuilder.append(HEXES.charAt((by & 0xF0) >> 4)).append(HEXES.charAt(by & 0xF));
        }
        return stringBuilder.toString();
    }
}

