/*
 * Decompiled with CFR 0.152.
 */
package cpw.mods.fml.common;

import com.google.common.base.Joiner;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.MapMaker;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import cpw.mods.fml.common.FMLLog;
import cpw.mods.fml.common.ICrashCallable;
import cpw.mods.fml.common.IFMLSidedHandler;
import cpw.mods.fml.common.InjectedModContainer;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.ModContainer;
import cpw.mods.fml.common.StartupQuery;
import cpw.mods.fml.common.WorldAccessContainer;
import cpw.mods.fml.common.eventhandler.EventBus;
import cpw.mods.fml.common.gameevent.InputEvent$KeyInputEvent;
import cpw.mods.fml.common.gameevent.InputEvent$MouseInputEvent;
import cpw.mods.fml.common.gameevent.PlayerEvent$ItemCraftedEvent;
import cpw.mods.fml.common.gameevent.PlayerEvent$ItemPickupEvent;
import cpw.mods.fml.common.gameevent.PlayerEvent$ItemSmeltedEvent;
import cpw.mods.fml.common.gameevent.PlayerEvent$PlayerChangedDimensionEvent;
import cpw.mods.fml.common.gameevent.PlayerEvent$PlayerLoggedInEvent;
import cpw.mods.fml.common.gameevent.PlayerEvent$PlayerLoggedOutEvent;
import cpw.mods.fml.common.gameevent.PlayerEvent$PlayerRespawnEvent;
import cpw.mods.fml.common.gameevent.TickEvent$ClientTickEvent;
import cpw.mods.fml.common.gameevent.TickEvent$Phase;
import cpw.mods.fml.common.gameevent.TickEvent$PlayerTickEvent;
import cpw.mods.fml.common.gameevent.TickEvent$RenderTickEvent;
import cpw.mods.fml.common.gameevent.TickEvent$ServerTickEvent;
import cpw.mods.fml.common.gameevent.TickEvent$WorldTickEvent;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.server.FMLServerHandler;
import fgm.IIIIiIiIIiIiIiIIiIiiiIiIIIiIIIiIIIIiIiiiiiIIiIiIiiiIIiiiIIIIiIiI;
import fgm.IiIIIIIiIIiiiIIIIIIIIIiIIiIIIIIIIIIIIIiiiiIiiIIIiIIIiiIiiIiIIIiI;
import fgm.IiiIIIIIIiIIiIiiIIiIIIIiIiiiiiiIIIIIiiIIIIiiIIIiiiiIIIiIiiiiIIII;
import fgm.IiiiiiiiIiIIIIiiIIIIIIIiiiiIiiIIiiIIiIiiiIIIIIiIIIiiIiiIiiiiIIII;
import fgm.iIIIIIiiIiIiIiiIiIIIiiIiiIiIIiiiiIIiIiiiiIiIiiiIiIIIIIIIIIiIiIiI;
import fgm.iIIIIiIiiIIIIiiIIiIiiIIIIIiIIiiiIIiiiIIiiiiiIiiiiIIiiIIIiIiIIIii;
import fgm.iIIiIIiiIiiiiIiIIIIiIIIIIIIIiIIiIIIiIiiiIIiiIiIiiiIIiiIiIIiiiiIi;
import fgm.iIIiiIiiIiIiIIiiiIIIIIiIIIIiIIIIiIiiiIIiiIiiiiIIIiIIIIiIIIiIIiiI;
import fgm.iIiIiIIIIiiiiiIIiiIiiIIiiIIIIiiIiIiIiiiIIiIIIiIiiIiiIiiIiiIIiiii;
import fgm.iiIIIIIIIIiIIIIiiIIIiIIIiiiiiIIIiIIiIIiIIiIiIIIiIiIIiIiiiiIIIIIi;
import fgm.iiiIiIIiiIiIiiIiIiIiIIiIiIiIIIIiIiIiiIIiIiiiiIiIIiiiIiiiiIIiIiiI;
import fgm.iiiiiIiIiiiIIiiIiiiiiIIIiIIiIIiIIIiiiIiiIiiIiiiiIiIiIiiiiiIiiiiI;
import java.io.File;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import modules.ru.amaz1ng.core.common.utils.annotations.ObfuscationIgnore;
import net.minecraft.server.MinecraftServer;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.Logger;

@ObfuscationIgnore
public class FMLCommonHandler {
    private static final FMLCommonHandler INSTANCE = new FMLCommonHandler();
    private IFMLSidedHandler sidedDelegate;
    private Class<?> forge;
    private boolean noForge;
    private List<String> brandings;
    private List<String> brandingsNoMC;
    private List<ICrashCallable> crashCallables = Lists.newArrayList((Object[])new ICrashCallable[]{Loader.instance().getCallableCrashInformation()});
    private Set<IiiIIIIIIiIIiIiiIIiIIIIiIiiiiiiIIIIIiiIIIIiiIIIiiiiIIIiIiiiiIIII> handlerSet = Sets.newSetFromMap((Map)new MapMaker().weakKeys().makeMap());
    private WeakReference<IiiIIIIIIiIIiIiiIIiIIIIiIiiiiiiIIIIIiiIIIIiiIIIiiiiIIIiIiiiiIIII> handlerToCheck;
    private EventBus eventBus = new EventBus();
    private volatile CountDownLatch exitLatch = null;

    public EventBus bus() {
        return this.eventBus;
    }

    public void beginLoading(IFMLSidedHandler handler) {
        this.sidedDelegate = handler;
        FMLLog.log("MinecraftForge", Level.INFO, "Attempting early MinecraftForge initialization", new Object[0]);
        this.callForgeMethod("initialize");
        this.callForgeMethod("registerCrashCallable");
        FMLLog.log("MinecraftForge", Level.INFO, "Completed early MinecraftForge initialization", new Object[0]);
    }

    public static FMLCommonHandler instance() {
        return INSTANCE;
    }

    public ModContainer findContainerFor(Object mod) {
        if (mod instanceof String) {
            return Loader.instance().getIndexedModList().get(mod);
        }
        return (ModContainer)Loader.instance().getReversedModObjectList().get(mod);
    }

    public Logger getFMLLogger() {
        return FMLLog.getLogger();
    }

    public Side getSide() {
        return this.sidedDelegate.getSide();
    }

    public Side getEffectiveSide() {
        Thread thread = Thread.currentThread();
        if (thread.getName().equals("Server thread")) {
            return Side.SERVER;
        }
        return Side.CLIENT;
    }

    public void raiseException(Throwable exception, String message, boolean stopGame) {
        FMLLog.log(Level.ERROR, exception, "Something raised an exception. The message was '%s'. 'stopGame' is %b", message, stopGame);
        if (stopGame) {
            this.getSidedDelegate().haltGame(message, exception);
        }
    }

    private Class<?> findMinecraftForge() {
        if (this.forge == null && !this.noForge) {
            try {
                this.forge = Class.forName("fgm.IiiIiiIIiIIIIIIiIIiiIiIIIIiiiIiiIiiIIIIIiiiIiIIiIIiIIiiIIiiiIiIi");
            }
            catch (Exception exception) {
                this.noForge = true;
            }
        }
        return this.forge;
    }

    private Object callForgeMethod(String method) {
        if (this.noForge) {
            return null;
        }
        try {
            return this.findMinecraftForge().getMethod(method, new Class[0]).invoke(null, new Object[0]);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public void computeBranding() {
        if (this.brandings == null) {
            ImmutableList.Builder builder = ImmutableList.builder();
            builder.add((Object)Loader.instance().getMCVersionString());
            builder.add((Object)Loader.instance().getMCPVersionString());
            builder.add((Object)("FML v" + Loader.instance().getFMLVersionString()));
            String string = (String)this.callForgeMethod("getBrandingVersion");
            if (!Strings.isNullOrEmpty((String)string)) {
                builder.add((Object)string);
            }
            if (this.sidedDelegate != null) {
                builder.addAll(this.sidedDelegate.getAdditionalBrandingInformation());
            }
            if (Loader.instance().getFMLBrandingProperties().containsKey("fmlbranding")) {
                builder.add((Object)Loader.instance().getFMLBrandingProperties().get("fmlbranding"));
            }
            int n = Loader.instance().getModList().size();
            int n2 = Loader.instance().getActiveModList().size();
            builder.add((Object)String.format("%d mod%s loaded, %d mod%s active", n, n != 1 ? "s" : "", n2, n2 != 1 ? "s" : ""));
            this.brandings = builder.build();
            this.brandingsNoMC = this.brandings.subList(1, this.brandings.size());
        }
    }

    public List<String> getBrandings(boolean includeMC) {
        if (this.brandings == null) {
            this.computeBranding();
        }
        return includeMC ? ImmutableList.copyOf(this.brandings) : ImmutableList.copyOf(this.brandingsNoMC);
    }

    public IFMLSidedHandler getSidedDelegate() {
        return this.sidedDelegate;
    }

    public void onPostServerTick() {
        this.bus().post(new TickEvent$ServerTickEvent(TickEvent$Phase.END));
    }

    public void onPostWorldTick(iIIiiIiiIiIiIIiiiIIIIIiIIIIiIIIIiIiiiIIiiIiiiiIIIiIIIIiIIIiIIiiI world) {
        this.bus().post(new TickEvent$WorldTickEvent(Side.SERVER, TickEvent$Phase.END, world));
    }

    public void onPreServerTick() {
        this.bus().post(new TickEvent$ServerTickEvent(TickEvent$Phase.START));
    }

    public void onPreWorldTick(iIIiiIiiIiIiIIiiiIIIIIiIIIIiIIIIiIiiiIIiiIiiiiIIIiIIIIiIIIiIIiiI world) {
        this.bus().post(new TickEvent$WorldTickEvent(Side.SERVER, TickEvent$Phase.START, world));
    }

    public boolean handleServerAboutToStart(MinecraftServer server) {
        return Loader.instance().serverAboutToStart(server);
    }

    public boolean handleServerStarting(MinecraftServer server) {
        return Loader.instance().serverStarting(server);
    }

    public void handleServerStarted() {
        Loader.instance().serverStarted();
        this.sidedDelegate.allowLogins();
    }

    public void handleServerStopping() {
        Loader.instance().serverStopping();
    }

    public File getSavesDirectory() {
        return this.sidedDelegate.getSavesDirectory();
    }

    public MinecraftServer getMinecraftServerInstance() {
        return this.sidedDelegate.getServer();
    }

    public void showGuiScreen(Object clientGuiElement) {
        this.sidedDelegate.showGuiScreen(clientGuiElement);
    }

    public void queryUser(StartupQuery query) {
        this.sidedDelegate.queryUser(query);
    }

    public void onServerStart(MinecraftServer dedicatedServer) {
        FMLServerHandler.IiiIIiIiIIiiIIIiiIiIiiiIIIIiiiiIiIiIiIIIIIiiIIIiiiIIiIIiIIIIiiii();
        this.sidedDelegate.beginServerLoading(dedicatedServer);
    }

    public void onServerStarted() {
        this.sidedDelegate.finishServerLoading();
    }

    public void onPreClientTick() {
        this.bus().post(new TickEvent$ClientTickEvent(TickEvent$Phase.START));
    }

    public void onPostClientTick() {
        this.bus().post(new TickEvent$ClientTickEvent(TickEvent$Phase.END));
    }

    public void onRenderTickStart(float timer) {
        this.bus().post(new TickEvent$RenderTickEvent(TickEvent$Phase.START, timer));
    }

    public void onRenderTickEnd(float timer) {
        this.bus().post(new TickEvent$RenderTickEvent(TickEvent$Phase.END, timer));
    }

    public void onPlayerPreTick(IiiiiiiiIiIIIIiiIIIIIIIiiiiIiiIIiiIIiIiiiIIIIIiIIIiiIiiIiiiiIIII player) {
        this.bus().post(new TickEvent$PlayerTickEvent(TickEvent$Phase.START, player));
    }

    public void onPlayerPostTick(IiiiiiiiIiIIIIiiIIIIIIIiiiiIiiIIiiIIiIiiiIIIIIiIIIiiIiiIiiiiIIII player) {
        this.bus().post(new TickEvent$PlayerTickEvent(TickEvent$Phase.END, player));
    }

    public void registerCrashCallable(ICrashCallable callable) {
        this.crashCallables.add(callable);
    }

    public void enhanceCrashReport(iiIIIIIIIIiIIIIiiIIIiIIIiiiiiIIIiIIiIIiIIiIiIIIiIiIIiIiiiiIIIIIi crashReport, IIIIiIiIIiIiIiIIiIiiiIiIIIiIIIiIIIIiIiiiiiIIiIiIiiiIIiiiIIIIiIiI category) {
        for (ICrashCallable iCrashCallable : this.crashCallables) {
            category.IiiIIiIiIIiiIIIiiIiIiiiIIIIiiiiIiIiIiIIIIIiiIIIiiiIIiIIiIIIIiiii(iCrashCallable.getLabel(), iCrashCallable);
        }
    }

    public void handleWorldDataSave(IiiIIIIIIiIIiIiiIIiIIIIiIiiiiiiIIIIIiiIIIIiiIIIiiiiIIIiIiiiiIIII handler, iiiiiIiIiiiIIiiIiiiiiIIIiIIiIIiIIIiiiIiiIiiIiiiiIiIiIiiiiiIiiiiI worldInfo, iiiIiIIiiIiIiiIiIiIiIIiIiIiIIIIiIiIiiIIiIiiiiIiIIiiiIiiiiIIiIiiI tagCompound) {
        for (ModContainer modContainer : Loader.instance().getModList()) {
            WorldAccessContainer worldAccessContainer;
            if (!(modContainer instanceof InjectedModContainer) || (worldAccessContainer = ((InjectedModContainer)modContainer).getWrappedWorldAccessContainer()) == null) continue;
            iiiIiIIiiIiIiiIiIiIiIIiIiIiIIIIiIiIiiIIiIiiiiIiIIiiiIiiiiIIiIiiI iiiIiIIiiIiIiiIiIiIiIIiIiIiIIIIiIiIiiIIiIiiiiIiIIiiiIiiiiIIiIiiI2 = worldAccessContainer.getDataForWriting(handler, worldInfo);
            tagCompound.IiiIIiIiIIiiIIIiiIiIiiiIIIIiiiiIiIiIiIIIIIiiIIIiiiIIiIIiIIIIiiii(modContainer.getModId(), iiiIiIIiiIiIiiIiIiIiIIiIiIiIIIIiIiIiiIIiIiiiiIiIIiiiIiiiiIIiIiiI2);
        }
    }

    public void handleWorldDataLoad(IiiIIIIIIiIIiIiiIIiIIIIiIiiiiiiIIIIIiiIIIIiiIIIiiiiIIIiIiiiiIIII handler, iiiiiIiIiiiIIiiIiiiiiIIIiIIiIIiIIIiiiIiiIiiIiiiiIiIiIiiiiiIiiiiI worldInfo, iiiIiIIiiIiIiiIiIiIiIIiIiIiIIIIiIiIiiIIiIiiiiIiIIiiiIiiiiIIiIiiI tagCompound) {
        if (this.getEffectiveSide() != Side.SERVER) {
            return;
        }
        if (this.handlerSet.contains(handler)) {
            return;
        }
        this.handlerSet.add(handler);
        this.handlerToCheck = new WeakReference<IiiIIIIIIiIIiIiiIIiIIIIiIiiiiiiIIIIIiiIIIIiiIIIiiiiIIIiIiiiiIIII>(handler);
        HashMap hashMap = Maps.newHashMap();
        worldInfo.IiiIIiIiIIiiIIIiiIiIiiiIIIIiiiiIiIiIiIIIIIiiIIIiiiIIiIIiIIIIiiii(hashMap);
        for (ModContainer modContainer : Loader.instance().getModList()) {
            WorldAccessContainer worldAccessContainer;
            if (!(modContainer instanceof InjectedModContainer) || (worldAccessContainer = ((InjectedModContainer)modContainer).getWrappedWorldAccessContainer()) == null) continue;
            worldAccessContainer.readData(handler, worldInfo, hashMap, tagCompound.IIIiiiiiiiiiIiiiiiiIIIIiiiIiIIiiiiIiiiIIIiiiiIIIIiiIIiIiIiiIIIII(modContainer.getModId()));
        }
    }

    public void confirmBackupLevelDatUse(IiiIIIIIIiIIiIiiIIiIIIIiIiiiiiiIIIIIiiIIIIiiIIIiiiiIIIiIiiiiIIII handler) {
        if (this.handlerToCheck == null || this.handlerToCheck.get() != handler) {
            this.handlerToCheck = null;
            return;
        }
        String string = "Forge Mod Loader detected that the backup level.dat is being used.\n\nThis may happen due to a bug or corruption, continuing can damage\nyour world beyond repair or lose data / progress.\n\nIt's recommended to create a world backup before continuing.";
        boolean bl = StartupQuery.confirm(string);
        if (!bl) {
            StartupQuery.abort();
        }
    }

    public boolean shouldServerBeKilledQuietly() {
        if (this.sidedDelegate == null) {
            return false;
        }
        return this.sidedDelegate.shouldServerShouldBeKilledQuietly();
    }

    public void expectServerStopped() {
        this.exitLatch = new CountDownLatch(1);
    }

    public void handleExit(int retVal) {
        CountDownLatch countDownLatch = this.exitLatch;
        if (countDownLatch != null) {
            try {
                FMLLog.info("Waiting for the server to terminate/save.", new Object[0]);
                if (!countDownLatch.await(10L, TimeUnit.SECONDS)) {
                    FMLLog.warning("The server didn't stop within 10 seconds, exiting anyway.", new Object[0]);
                } else {
                    FMLLog.info("Server terminated.", new Object[0]);
                }
            }
            catch (InterruptedException interruptedException) {
                FMLLog.warning("Interrupted wait, exiting.", new Object[0]);
            }
        }
        System.exit(retVal);
    }

    public void handleServerStopped() {
        CountDownLatch countDownLatch;
        this.sidedDelegate.serverStopped();
        MinecraftServer minecraftServer = this.getMinecraftServerInstance();
        Loader.instance().serverStopped();
        if (minecraftServer != null) {
            minecraftServer.IIIiIIiiiIiIIIiiiIIIiiIiIIIiiiIIIiIIIIiiiIiiiiiiIiiiiiIiiiIiiIII = false;
        }
        if ((countDownLatch = this.exitLatch) != null) {
            countDownLatch.countDown();
            this.exitLatch = null;
        }
    }

    public String getModName() {
        ArrayList arrayList = Lists.newArrayListWithExpectedSize((int)3);
        arrayList.add("fml");
        if (!this.noForge) {
            arrayList.add("forge");
        }
        if (Loader.instance().getFMLBrandingProperties().containsKey("snooperbranding")) {
            arrayList.add(Loader.instance().getFMLBrandingProperties().get("snooperbranding"));
        }
        return Joiner.on((char)',').join((Iterable)arrayList);
    }

    public void addModToResourcePack(ModContainer container) {
        this.sidedDelegate.addModAsResource(container);
    }

    public String getCurrentLanguage() {
        return this.sidedDelegate.getCurrentLanguage();
    }

    public void bootstrap() {
    }

    public iIIiIIiiIiiiiIiIIIIiIIIIIIIIiIIiIIIiIiiiIIiiIiIiiiIIiiIiIIiiiiIi getClientToServerNetworkManager() {
        return this.sidedDelegate.getClientToServerNetworkManager();
    }

    public void fireMouseInput() {
        this.bus().post(new InputEvent$MouseInputEvent());
    }

    public void fireKeyInput() {
        this.bus().post(new InputEvent$KeyInputEvent());
    }

    public void firePlayerChangedDimensionEvent(IiiiiiiiIiIIIIiiIIIIIIIiiiiIiiIIiiIIiIiiiIIIIIiIIIiiIiiIiiiiIIII player, int fromDim, int toDim) {
        this.bus().post(new PlayerEvent$PlayerChangedDimensionEvent(player, fromDim, toDim));
    }

    public void firePlayerLoggedIn(IiiiiiiiIiIIIIiiIIIIIIIiiiiIiiIIiiIIiIiiiIIIIIiIIIiiIiiIiiiiIIII player) {
        this.bus().post(new PlayerEvent$PlayerLoggedInEvent(player));
    }

    public void firePlayerLoggedOut(IiiiiiiiIiIIIIiiIIIIIIIiiiiIiiIIiiIIiIiiiIIIIIiIIIiiIiiIiiiiIIII player) {
        this.bus().post(new PlayerEvent$PlayerLoggedOutEvent(player));
    }

    public void firePlayerRespawnEvent(IiiiiiiiIiIIIIiiIIIIIIIiiiiIiiIIiiIIiIiiiIIIIIiIIIiiIiiIiiiiIIII player) {
        this.bus().post(new PlayerEvent$PlayerRespawnEvent(player));
    }

    public void firePlayerItemPickupEvent(IiiiiiiiIiIIIIiiIIIIIIIiiiiIiiIIiiIIiIiiiIIIIIiIIIiiIiiIiiiiIIII player, IiIIIIIiIIiiiIIIIIIIIIiIIiIIIIIIIIIIIIiiiiIiiIIIiIIIiiIiiIiIIIiI item) {
        this.bus().post(new PlayerEvent$ItemPickupEvent(player, item));
    }

    public void firePlayerCraftingEvent(IiiiiiiiIiIIIIiiIIIIIIIiiiiIiiIIiiIIiIiiiIIIIIiIIIiiIiiIiiiiIIII player, iIIIIiIiiIIIIiiIIiIiiIIIIIiIIiiiIIiiiIIiiiiiIiiiiIIiiIIIiIiIIIii crafted, iIIIIIiiIiIiIiiIiIIIiiIiiIiIIiiiiIIiIiiiiIiIiiiIiIIIIIIIIIiIiIiI craftMatrix) {
        this.bus().post(new PlayerEvent$ItemCraftedEvent(player, crafted, craftMatrix));
    }

    public void firePlayerSmeltedEvent(IiiiiiiiIiIIIIiiIIIIIIIiiiiIiiIIiiIIiIiiiIIIIIiIIIiiIiiIiiiiIIII player, iIIIIiIiiIIIIiiIIiIiiIIIIIiIIiiiIIiiiIIiiiiiIiiiiIIiiIIIiIiIIIii smelted) {
        this.bus().post(new PlayerEvent$ItemSmeltedEvent(player, smelted));
    }

    public iIiIiIIIIiiiiiIIiiIiiIIiiIIIIiiIiIiIiiiIIiIIIiIiiIiiIiiIiiIIiiii getClientPlayHandler() {
        return this.sidedDelegate.getClientPlayHandler();
    }

    public void waitForPlayClient() {
        this.sidedDelegate.waitForPlayClient();
    }

    public void fireNetRegistrationEvent(iIIiIIiiIiiiiIiIIIIiIIIIIIIIiIIiIIIiIiiiIIiiIiIiiiIIiiIiIIiiiiIi manager, Set<String> channelSet, String channel, Side side) {
        this.sidedDelegate.fireNetRegistrationEvent(this.bus(), manager, channelSet, channel, side);
    }

    public boolean shouldAllowPlayerLogins() {
        return this.sidedDelegate.shouldAllowPlayerLogins();
    }

    public void processWindowMessages() {
        if (this.sidedDelegate == null) {
            return;
        }
        this.sidedDelegate.processWindowMessages();
    }

    public void exitJava(int exitCode, boolean hardExit) {
        FMLLog.log(Level.INFO, "Java has been asked to exit (code %d) by %s.", exitCode, Thread.currentThread().getStackTrace()[1]);
        if (hardExit) {
            FMLLog.log(Level.INFO, "This is an abortive exit and could cause world corruption or other things", new Object[0]);
        }
        if (Boolean.parseBoolean(System.getProperty("fml.debugExit", "false"))) {
            FMLLog.log(Level.INFO, new Throwable(), "Exit trace", new Object[0]);
        } else {
            FMLLog.log(Level.INFO, "If this was an unexpected exit, use -Dfml.debugExit=true as a JVM argument to find out where it was called", new Object[0]);
        }
        if (hardExit) {
            Runtime.getRuntime().halt(exitCode);
        } else {
            Runtime.getRuntime().exit(exitCode);
        }
    }

    public String stripSpecialChars(String message) {
        return this.sidedDelegate != null ? this.sidedDelegate.stripSpecialChars(message) : message;
    }
}

