/*
 * Decompiled with CFR 0.152.
 */
package cpw.mods.fml.common;

import com.google.common.base.Function;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.BiMap;
import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableBiMap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.eventbus.EventBus;
import com.google.common.eventbus.Subscribe;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.FMLLog;
import cpw.mods.fml.common.IFMLHandledException;
import cpw.mods.fml.common.LoadController$FMLSecurityManager;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.LoaderException;
import cpw.mods.fml.common.LoaderState;
import cpw.mods.fml.common.LoaderState$ModState;
import cpw.mods.fml.common.ModContainer;
import cpw.mods.fml.common.ProgressManager;
import cpw.mods.fml.common.ProgressManager$ProgressBar;
import cpw.mods.fml.common.event.FMLEvent;
import cpw.mods.fml.common.event.FMLLoadEvent;
import cpw.mods.fml.common.event.FMLModDisabledEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.event.FMLStateEvent;
import cpw.mods.fml.common.functions.ArtifactVersionNameFunction;
import cpw.mods.fml.common.versioning.ArtifactVersion;
import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import modules.ru.amaz1ng.core.common.utils.annotations.ObfuscationIgnore;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.ThreadContext;

@ObfuscationIgnore
public class LoadController {
    @ObfuscationIgnore
    private Loader loader;
    @ObfuscationIgnore
    private EventBus masterChannel;
    @ObfuscationIgnore
    private ImmutableMap<String, EventBus> eventChannels;
    @ObfuscationIgnore
    private LoaderState state;
    @ObfuscationIgnore
    private Multimap<String, LoaderState$ModState> modStates = ArrayListMultimap.create();
    @ObfuscationIgnore
    private Multimap<String, Throwable> errors = ArrayListMultimap.create();
    @ObfuscationIgnore
    private List<ModContainer> activeModList = Lists.newArrayList();
    @ObfuscationIgnore
    private ModContainer activeContainer;
    @ObfuscationIgnore
    private BiMap<ModContainer, Object> modObjectList;
    @ObfuscationIgnore
    private ListMultimap<String, ModContainer> packageOwners;
    @ObfuscationIgnore
    private LoadController$FMLSecurityManager accessibleManager = new LoadController$FMLSecurityManager(this);

    @ObfuscationIgnore
    public LoadController(Loader loader) {
        this.loader = loader;
        this.masterChannel = new EventBus("FMLMainChannel");
        this.masterChannel.register((Object)this);
        this.state = LoaderState.NOINIT;
        this.packageOwners = ArrayListMultimap.create();
    }

    @ObfuscationIgnore
    void disableMod(ModContainer mod) {
        HashMap hashMap = Maps.newHashMap(this.eventChannels);
        String string = mod.getModId();
        EventBus eventBus = (EventBus)hashMap.remove(string);
        eventBus.post((Object)new FMLModDisabledEvent());
        if (this.errors.get((Object)string).isEmpty()) {
            this.eventChannels = ImmutableMap.copyOf((Map)hashMap);
            this.modStates.put((Object)string, (Object)LoaderState$ModState.DISABLED);
            this.modObjectList.remove((Object)mod);
            this.activeModList.remove(mod);
        }
    }

    @Subscribe
    @ObfuscationIgnore
    public void buildModList(FMLLoadEvent event) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (ModContainer modContainer2 : this.loader.getModList()) {
            EventBus eventBus;
            boolean bl = modContainer2.registerBus(eventBus = new EventBus(modContainer2.getModId()), this);
            if (bl) {
                this.activeModList.add(modContainer2);
                this.modStates.put((Object)modContainer2.getModId(), (Object)LoaderState$ModState.UNLOADED);
                builder.put((Object)modContainer2.getModId(), (Object)eventBus);
                continue;
            }
            FMLLog.log(modContainer2.getModId(), Level.WARN, "Mod %s has been disabled through configuration", modContainer2.getModId());
            this.modStates.put((Object)modContainer2.getModId(), (Object)LoaderState$ModState.UNLOADED);
            this.modStates.put((Object)modContainer2.getModId(), (Object)LoaderState$ModState.DISABLED);
        }
        this.loader.getModList().parallelStream().forEach(modContainer -> FMLCommonHandler.instance().addModToResourcePack((ModContainer)modContainer));
        this.eventChannels = builder.build();
    }

    @ObfuscationIgnore
    public void distributeStateMessage(LoaderState state, Object ... eventData) {
        if (state.hasEvent()) {
            this.masterChannel.post((Object)state.getEvent(eventData));
        }
    }

    @ObfuscationIgnore
    public void transition(LoaderState desiredState, boolean forceState) {
        LoaderState loaderState = this.state;
        this.state = this.state.transition(!this.errors.isEmpty());
        if (this.state != desiredState && !forceState) {
            Throwable throwable = null;
            FMLLog.severe("Fatal errors were detected during the transition from %s to %s. Loading cannot continue", new Object[]{loaderState, desiredState});
            StringBuilder stringBuilder = new StringBuilder();
            this.printModStates(stringBuilder);
            FMLLog.severe("%s", stringBuilder.toString());
            if (this.errors.size() > 0) {
                FMLLog.severe("The following problems were captured during this phase", new Object[0]);
                for (Map.Entry entry : this.errors.entries()) {
                    FMLLog.log(Level.ERROR, (Throwable)entry.getValue(), "Caught exception from %s", entry.getKey());
                    if (entry.getValue() instanceof IFMLHandledException) {
                        throwable = (Throwable)entry.getValue();
                        continue;
                    }
                    if (throwable != null) continue;
                    throwable = (Throwable)entry.getValue();
                }
            } else {
                FMLLog.severe("The ForgeModLoader state engine has become corrupted. Probably, a state was missed by and invalid modification to a base classForgeModLoader depends on. This is a critical error and not recoverable. Investigate any modifications to base classes outside ofForgeModLoader, especially Optifine, to see if there are fixes available.", new Object[0]);
                throw new RuntimeException("The ForgeModLoader state engine is invalid");
            }
            if (throwable != null && throwable instanceof RuntimeException) {
                throw (RuntimeException)throwable;
            }
            throw new LoaderException(throwable);
        }
        if (this.state != desiredState && forceState) {
            FMLLog.info("The state engine was in incorrect state %s and forced into state %s. Errors may have been discarded.", new Object[]{this.state, desiredState});
            this.forceState(desiredState);
        }
    }

    @ObfuscationIgnore
    public ModContainer activeContainer() {
        return this.activeContainer != null ? this.activeContainer : this.findActiveContainerFromStack();
    }

    @Subscribe
    @ObfuscationIgnore
    public void propogateStateMessage(FMLEvent stateEvent) {
        if (stateEvent instanceof FMLPreInitializationEvent) {
            this.modObjectList = this.buildModObjectList();
        }
        ProgressManager$ProgressBar progressManager$ProgressBar = ProgressManager.push(stateEvent.description(), this.activeModList.size(), true);
        for (ModContainer modContainer : this.activeModList) {
            progressManager$ProgressBar.step(modContainer.getName());
            this.sendEventToModContainer(stateEvent, modContainer);
        }
        ProgressManager.pop(progressManager$ProgressBar);
    }

    @ObfuscationIgnore
    private void sendEventToModContainer(FMLEvent stateEvent, ModContainer mc) {
        String string = mc.getModId();
        Collection collection = Collections2.transform(mc.getRequirements(), (Function)new ArtifactVersionNameFunction());
        for (ArtifactVersion artifactVersion : mc.getDependencies()) {
            if (artifactVersion.getLabel() == null || !collection.contains(artifactVersion.getLabel()) || !this.modStates.containsEntry((Object)artifactVersion.getLabel(), (Object)LoaderState$ModState.ERRORED)) continue;
            FMLLog.log(string, Level.ERROR, "Skipping event %s and marking errored mod %s since required dependency %s has errored", stateEvent.getEventType(), string, artifactVersion.getLabel());
            this.modStates.put((Object)string, (Object)LoaderState$ModState.ERRORED);
            return;
        }
        this.activeContainer = mc;
        stateEvent.applyModContainer(this.activeContainer());
        ThreadContext.put((String)"mod", (String)string);
        FMLLog.log(string, Level.TRACE, "Sending event %s to mod %s", stateEvent.getEventType(), string);
        ((EventBus)this.eventChannels.get((Object)string)).post((Object)stateEvent);
        FMLLog.log(string, Level.TRACE, "Sent event %s to mod %s", stateEvent.getEventType(), string);
        ThreadContext.remove((String)"mod");
        this.activeContainer = null;
        if (stateEvent instanceof FMLStateEvent) {
            if (!this.errors.containsKey((Object)string)) {
                this.modStates.put((Object)string, (Object)((FMLStateEvent)stateEvent).getModState());
            } else {
                this.modStates.put((Object)string, (Object)LoaderState$ModState.ERRORED);
            }
        }
    }

    @ObfuscationIgnore
    public ImmutableBiMap<ModContainer, Object> buildModObjectList() {
        ImmutableBiMap.Builder builder = ImmutableBiMap.builder();
        for (ModContainer modContainer : this.activeModList) {
            if (!modContainer.isImmutable() && modContainer.getMod() != null) {
                builder.put((Object)modContainer, modContainer.getMod());
                List<String> list = modContainer.getOwnedPackages();
                for (String string : list) {
                    this.packageOwners.put((Object)string, (Object)modContainer);
                }
            }
            if (modContainer.getMod() != null || modContainer.isImmutable() || this.state == LoaderState.CONSTRUCTING) continue;
            FMLLog.severe("There is a severe problem with %s - it appears not to have constructed correctly", modContainer.getModId());
            if (this.state == LoaderState.CONSTRUCTING) continue;
            this.errorOccurred(modContainer, new RuntimeException());
        }
        return builder.build();
    }

    @ObfuscationIgnore
    public void errorOccurred(ModContainer modContainer, Throwable exception) {
        if (exception instanceof InvocationTargetException) {
            this.errors.put((Object)modContainer.getModId(), (Object)((InvocationTargetException)exception).getCause());
        } else {
            this.errors.put((Object)modContainer.getModId(), (Object)exception);
        }
    }

    @ObfuscationIgnore
    public void printModStates(StringBuilder ret) {
        ret.append("\n\tStates:");
        for (LoaderState$ModState loaderState$ModState : LoaderState$ModState.values()) {
            ret.append(" '").append(loaderState$ModState.getMarker()).append("' = ").append(loaderState$ModState.toString());
        }
        for (ModContainer modContainer : this.loader.getModList()) {
            ret.append("\n\t");
            for (LoaderState$ModState loaderState$ModState : this.modStates.get((Object)modContainer.getModId())) {
                ret.append(loaderState$ModState.getMarker());
            }
            ret.append("\t").append(modContainer.getModId()).append("{").append(modContainer.getVersion()).append("} [").append(modContainer.getName()).append("] (").append(modContainer.getSource().getName()).append(") ");
        }
    }

    @ObfuscationIgnore
    public List<ModContainer> getActiveModList() {
        return this.activeModList;
    }

    @ObfuscationIgnore
    public LoaderState$ModState getModState(ModContainer selectedMod) {
        return (LoaderState$ModState)((Object)Iterables.getLast((Iterable)this.modStates.get((Object)selectedMod.getModId()), (Object)((Object)LoaderState$ModState.AVAILABLE)));
    }

    @ObfuscationIgnore
    public void distributeStateMessage(Class<?> customEvent) {
        try {
            this.masterChannel.post(customEvent.newInstance());
        }
        catch (Exception exception) {
            FMLLog.log(Level.ERROR, exception, "An unexpected exception", new Object[0]);
            throw new LoaderException(exception);
        }
    }

    @ObfuscationIgnore
    public BiMap<ModContainer, Object> getModObjectList() {
        if (this.modObjectList == null) {
            FMLLog.severe("Detected an attempt by a mod %s to perform game activity during mod construction. This is a serious programming error.", this.activeContainer);
            return this.buildModObjectList();
        }
        return ImmutableBiMap.copyOf(this.modObjectList);
    }

    @ObfuscationIgnore
    public boolean isInState(LoaderState state) {
        return this.state == state;
    }

    @ObfuscationIgnore
    boolean hasReachedState(LoaderState state) {
        return this.state.ordinal() >= state.ordinal() && this.state != LoaderState.ERRORED;
    }

    @ObfuscationIgnore
    void forceState(LoaderState newState) {
        this.state = newState;
    }

    @ObfuscationIgnore
    private ModContainer findActiveContainerFromStack() {
        for (Class<?> clazz : this.getCallingStack()) {
            String string;
            int n = clazz.getName().lastIndexOf(46);
            if (n == -1 || !this.packageOwners.containsKey((Object)(string = clazz.getName().substring(0, n)))) continue;
            return (ModContainer)this.packageOwners.get((Object)string).get(0);
        }
        return null;
    }

    @ObfuscationIgnore
    Class<?>[] getCallingStack() {
        return this.accessibleManager.getStackClasses();
    }

    @ObfuscationIgnore
    LoaderState getState() {
        return this.state;
    }
}

