/*
 * Decompiled with CFR 0.152.
 */
package cpw.mods.fml.common;

import com.google.common.base.Throwables;
import com.google.common.collect.Maps;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.JsonParser;
import cpw.mods.fml.common.FMLLog;
import cpw.mods.fml.common.MetadataCollection$ArtifactVersionAdapter;
import cpw.mods.fml.common.ModMetadata;
import cpw.mods.fml.common.versioning.ArtifactVersion;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Map;
import modules.ru.amaz1ng.core.common.utils.annotations.ObfuscationIgnore;
import org.apache.logging.log4j.Level;

@ObfuscationIgnore
public class MetadataCollection {
    @ObfuscationIgnore
    private String modListVersion;
    @ObfuscationIgnore
    private ModMetadata[] modList;
    @ObfuscationIgnore
    private Map<String, ModMetadata> metadatas = Maps.newHashMap();

    @ObfuscationIgnore
    public static MetadataCollection from(InputStream inputStream, String sourceName) {
        if (inputStream == null) {
            return new MetadataCollection();
        }
        InputStreamReader inputStreamReader = new InputStreamReader(inputStream);
        try {
            MetadataCollection metadataCollection;
            Gson gson = new GsonBuilder().registerTypeAdapter(ArtifactVersion.class, (Object)new MetadataCollection$ArtifactVersionAdapter()).create();
            JsonParser jsonParser = new JsonParser();
            JsonElement jsonElement = jsonParser.parse((Reader)inputStreamReader);
            if (jsonElement.isJsonArray()) {
                metadataCollection = new MetadataCollection();
                JsonArray jsonArray = jsonElement.getAsJsonArray();
                metadataCollection.modList = new ModMetadata[jsonArray.size()];
                int n = 0;
                for (JsonElement jsonElement2 : jsonArray) {
                    metadataCollection.modList[n++] = (ModMetadata)gson.fromJson(jsonElement2, ModMetadata.class);
                }
            } else {
                metadataCollection = (MetadataCollection)gson.fromJson(jsonElement, MetadataCollection.class);
            }
            metadataCollection.parseModMetadataList();
            return metadataCollection;
        }
        catch (JsonParseException jsonParseException) {
            FMLLog.log(Level.ERROR, jsonParseException, "The mcmod.info file in %s cannot be parsed as valid JSON. It will be ignored", sourceName);
            return new MetadataCollection();
        }
        catch (Exception exception) {
            throw Throwables.propagate((Throwable)exception);
        }
    }

    @ObfuscationIgnore
    private void parseModMetadataList() {
        for (ModMetadata modMetadata : this.modList) {
            this.metadatas.put(modMetadata.modId, modMetadata);
        }
    }

    @ObfuscationIgnore
    public ModMetadata getMetadataForId(String modId, Map<String, Object> extraData) {
        if (!this.metadatas.containsKey(modId)) {
            ModMetadata modMetadata = new ModMetadata();
            modMetadata.modId = modId;
            modMetadata.name = (String)extraData.get("name");
            modMetadata.version = (String)extraData.get("version");
            modMetadata.autogenerated = true;
            this.metadatas.put(modId, modMetadata);
        }
        return this.metadatas.get(modId);
    }
}

