/*
 * Decompiled with CFR 0.152.
 */
package cpw.mods.fml.common;

import com.google.common.base.Throwables;
import com.google.common.collect.Maps;
import cpw.mods.fml.common.FMLLog;
import cpw.mods.fml.common.FMLModContainer;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.ModContainer;
import cpw.mods.fml.common.discovery.ModCandidate;
import cpw.mods.fml.common.discovery.asm.ASMModParser;
import cpw.mods.fml.common.discovery.asm.ModAnnotation;
import java.io.File;
import java.lang.reflect.Constructor;
import java.util.Map;
import java.util.regex.Pattern;
import modules.ru.amaz1ng.core.common.utils.annotations.ObfuscationIgnore;
import org.apache.logging.log4j.Level;
import org.objectweb.asm.Type;

@ObfuscationIgnore
public class ModContainerFactory {
    public static Map<Type, Constructor<? extends ModContainer>> modTypes = Maps.newHashMap();
    private static Pattern modClass = Pattern.compile(".*(\\.|)(mod\\_[^\\s$]+)$");
    private static ModContainerFactory INSTANCE = new ModContainerFactory();

    private ModContainerFactory() {
        this.registerContainerType(Type.getType(Mod.class), FMLModContainer.class);
    }

    public static ModContainerFactory instance() {
        return INSTANCE;
    }

    public void registerContainerType(Type type, Class<? extends ModContainer> container) {
        try {
            Constructor<? extends ModContainer> constructor = container.getConstructor(String.class, ModCandidate.class, Map.class);
            modTypes.put(type, constructor);
        }
        catch (Exception exception) {
            FMLLog.log(Level.ERROR, exception, "Critical error : cannot register mod container type %s, it has an invalid constructor", new Object[0]);
            Throwables.propagate((Throwable)exception);
        }
    }

    public ModContainer build(ASMModParser modParser, File modSource, ModCandidate container) {
        String string = modParser.getASMType().getClassName();
        if (modParser.isBaseMod(container.getRememberedBaseMods()) && modClass.matcher(string).find()) {
            FMLLog.severe("Found a BaseMod type mod %s", string);
            FMLLog.severe("This will not be loaded and will be ignored. ModLoader mechanisms are no longer available.", new Object[0]);
        } else if (modClass.matcher(string).find()) {
            FMLLog.fine("Identified a class %s following modloader naming convention but not directly a BaseMod or currently seen subclass", string);
            container.rememberModCandidateType(modParser);
        } else if (modParser.isBaseMod(container.getRememberedBaseMods())) {
            FMLLog.fine("Found a basemod %s of non-standard naming format", string);
            container.rememberBaseModType(string);
        }
        for (ModAnnotation modAnnotation : modParser.getAnnotations()) {
            if (!modTypes.containsKey(modAnnotation.getASMType())) continue;
            FMLLog.fine("Identified a mod of type %s (%s) - loading", modAnnotation.getASMType(), string);
            try {
                return modTypes.get(modAnnotation.getASMType()).newInstance(string, container, modAnnotation.getValues());
            }
            catch (Exception exception) {
                FMLLog.log(Level.ERROR, exception, "Unable to construct %s container", modAnnotation.getASMType().getClassName());
                return null;
            }
        }
        return null;
    }
}

