/*
 * Decompiled with CFR 0.152.
 */
package cpw.mods.fml.common.asm.transformers;

import com.google.common.base.Charsets;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ListMultimap;
import com.google.common.io.LineProcessor;
import com.google.common.io.Resources;
import cpw.mods.fml.common.asm.transformers.MarkerTransformer$1;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import modules.ru.amaz1ng.core.common.utils.annotations.ObfuscationIgnore;
import net.minecraft.launchwrapper.IClassTransformer;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.tree.ClassNode;

@ObfuscationIgnore
public class MarkerTransformer
implements IClassTransformer {
    private ListMultimap<String, String> markers = ArrayListMultimap.create();

    public MarkerTransformer() {
        this("fml_marker.cfg");
    }

    protected MarkerTransformer(String rulesFile) {
        this.readMapFile(rulesFile);
    }

    private void readMapFile(String rulesFile) {
        File file = new File(rulesFile);
        URL uRL = file.exists() ? file.toURI().toURL() : Resources.getResource((String)rulesFile);
        Resources.readLines((URL)uRL, (Charset)Charsets.UTF_8, (LineProcessor)new MarkerTransformer$1(this));
    }

    public byte[] transform(String name, String transformedName, byte[] bytes) {
        if (bytes == null) {
            return null;
        }
        if (!this.markers.containsKey((Object)name)) {
            return bytes;
        }
        ClassNode classNode = new ClassNode();
        ClassReader classReader = new ClassReader(bytes);
        classReader.accept((ClassVisitor)classNode, 0);
        for (String string : this.markers.get((Object)name)) {
            classNode.interfaces.add(string);
        }
        ClassWriter classWriter = new ClassWriter(1);
        classNode.accept((ClassVisitor)classWriter);
        return classWriter.toByteArray();
    }

    public static void main(String[] args) {
        if (args.length < 2) {
            System.out.println("Usage: MarkerTransformer <JarPath> <MapFile> [MapFile2]... ");
            return;
        }
        boolean bl = false;
        MarkerTransformer[] markerTransformerArray = new MarkerTransformer[args.length - 1];
        for (int i = 1; i < args.length; ++i) {
            try {
                markerTransformerArray[i - 1] = new MarkerTransformer(args[i]);
                bl = true;
                continue;
            }
            catch (IOException iOException) {
                System.out.println("Could not read Transformer Map: " + args[i]);
                iOException.printStackTrace();
            }
        }
        if (!bl) {
            System.out.println("Culd not find a valid transformer to perform");
            return;
        }
        File file = new File(args[0]);
        File file2 = new File(args[0] + ".ATBack");
        if (!file.exists() && !file2.exists()) {
            System.out.println("Could not find target jar: " + file);
            return;
        }
        if (!file.renameTo(file2)) {
            System.out.println("Could not rename file: " + file + " -> " + file2);
            return;
        }
        try {
            MarkerTransformer.processJar(file2, file, markerTransformerArray);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        if (!file2.delete()) {
            System.out.println("Could not delete temp file: " + file2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void processJar(File inFile, File outFile, MarkerTransformer[] transformers) {
        ZipInputStream zipInputStream = null;
        ZipOutputStream zipOutputStream = null;
        try {
            ZipEntry zipEntry;
            try {
                zipInputStream = new ZipInputStream(new BufferedInputStream(new FileInputStream(inFile)));
            }
            catch (FileNotFoundException fileNotFoundException) {
                throw new FileNotFoundException("Could not open input file: " + fileNotFoundException.getMessage());
            }
            try {
                zipOutputStream = new ZipOutputStream(new BufferedOutputStream(new FileOutputStream(outFile)));
            }
            catch (FileNotFoundException fileNotFoundException) {
                throw new FileNotFoundException("Could not open output file: " + fileNotFoundException.getMessage());
            }
            while ((zipEntry = zipInputStream.getNextEntry()) != null) {
                ZipEntry zipEntry2;
                int n;
                if (zipEntry.isDirectory()) {
                    zipOutputStream.putNextEntry(zipEntry);
                    continue;
                }
                byte[] byArray = new byte[4096];
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                do {
                    if ((n = zipInputStream.read(byArray)) <= 0) continue;
                    byteArrayOutputStream.write(byArray, 0, n);
                } while (n != -1);
                byte[] byArray2 = byteArrayOutputStream.toByteArray();
                String string = zipEntry.getName();
                if (string.endsWith(".class") && !string.startsWith(".")) {
                    zipEntry2 = new ClassNode();
                    ClassReader classReader = new ClassReader(byArray2);
                    classReader.accept((ClassVisitor)zipEntry2, 0);
                    String string2 = ((ClassNode)zipEntry2).name.replace('/', '.').replace('\\', '.');
                    for (MarkerTransformer markerTransformer : transformers) {
                        byArray2 = markerTransformer.transform(string2, string2, byArray2);
                    }
                }
                zipEntry2 = new ZipEntry(string);
                zipOutputStream.putNextEntry(zipEntry2);
                zipOutputStream.write(byArray2);
            }
        }
        finally {
            if (zipOutputStream != null) {
                try {
                    zipOutputStream.close();
                }
                catch (IOException iOException) {}
            }
            if (zipInputStream != null) {
                try {
                    zipInputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    static /* synthetic */ ListMultimap access$000(MarkerTransformer x0) {
        return x0.markers;
    }
}

