/*
 * Decompiled with CFR 0.152.
 */
package cpw.mods.fml.common.discovery;

import com.google.common.collect.Lists;
import cpw.mods.fml.common.FMLLog;
import cpw.mods.fml.common.LoaderException;
import cpw.mods.fml.common.MetadataCollection;
import cpw.mods.fml.common.ModContainer;
import cpw.mods.fml.common.ModContainerFactory;
import cpw.mods.fml.common.discovery.ASMDataTable;
import cpw.mods.fml.common.discovery.ITypeDiscoverer;
import cpw.mods.fml.common.discovery.ModCandidate;
import cpw.mods.fml.common.discovery.asm.ASMModParser;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.jar.JarFile;
import java.util.regex.Matcher;
import java.util.zip.ZipEntry;
import modules.ru.amaz1ng.core.common.utils.annotations.ObfuscationIgnore;

@ObfuscationIgnore
public class JarDiscoverer
implements ITypeDiscoverer {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<ModContainer> discover(ModCandidate candidate, ASMDataTable table) {
        ArrayList arrayList = Lists.newArrayList();
        FMLLog.fine("Examining file %s for potential mods", candidate.getModContainer().getName());
        JarFile jarFile = null;
        try {
            jarFile = new JarFile(candidate.getModContainer());
            if (jarFile.getManifest() != null && (jarFile.getManifest().getMainAttributes().get("FMLCorePlugin") != null || jarFile.getManifest().getMainAttributes().get("TweakClass") != null)) {
                FMLLog.finer("Ignoring coremod or tweak system %s", candidate.getModContainer());
                ArrayList arrayList2 = arrayList;
                return arrayList2;
            }
            ZipEntry zipEntry = jarFile.getEntry("mcmod.info");
            MetadataCollection metadataCollection = null;
            if (zipEntry != null) {
                FMLLog.finer("Located mcmod.info file in file %s", candidate.getModContainer().getName());
                metadataCollection = MetadataCollection.from(jarFile.getInputStream(zipEntry), candidate.getModContainer().getName());
            } else {
                FMLLog.fine("The mod container %s appears to be missing an mcmod.info file", candidate.getModContainer().getName());
                metadataCollection = MetadataCollection.from(null, "");
            }
            for (ZipEntry zipEntry2 : Collections.list(jarFile.entries())) {
                ASMModParser aSMModParser;
                Matcher matcher;
                if (zipEntry2.getName() != null && zipEntry2.getName().startsWith("__MACOSX") || !(matcher = classFile.matcher(zipEntry2.getName())).matches()) continue;
                try {
                    aSMModParser = new ASMModParser(jarFile.getInputStream(zipEntry2));
                    candidate.addClassEntry(zipEntry2.getName());
                }
                catch (LoaderException loaderException) {
                    jarFile.close();
                    throw loaderException;
                }
                aSMModParser.validate();
                aSMModParser.sendToTable(table, candidate);
                ModContainer modContainer = ModContainerFactory.instance().build(aSMModParser, candidate.getModContainer(), candidate);
                if (modContainer == null) continue;
                table.addContainer(modContainer);
                arrayList.add(modContainer);
                modContainer.bindMetadata(metadataCollection);
            }
        }
        catch (Exception exception) {
        }
        finally {
            if (jarFile != null) {
                try {
                    jarFile.close();
                }
                catch (Exception exception) {}
            }
        }
        return arrayList;
    }
}

