/*
 * Decompiled with CFR 0.152.
 */
package cpw.mods.fml.common.event;

import cpw.mods.fml.common.FMLModContainer;
import cpw.mods.fml.common.LoaderState$ModState;
import cpw.mods.fml.common.ModContainer;
import cpw.mods.fml.common.ModMetadata;
import cpw.mods.fml.common.discovery.ASMDataTable;
import cpw.mods.fml.common.event.FMLStateEvent;
import java.io.File;
import java.security.CodeSource;
import java.security.cert.Certificate;
import java.util.Properties;
import modules.ru.amaz1ng.core.common.utils.annotations.ObfuscationIgnore;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@ObfuscationIgnore
public class FMLPreInitializationEvent
extends FMLStateEvent {
    @ObfuscationIgnore
    private ModMetadata modMetadata;
    @ObfuscationIgnore
    private File sourceFile;
    @ObfuscationIgnore
    private File configurationDir;
    @ObfuscationIgnore
    private File suggestedConfigFile;
    @ObfuscationIgnore
    private ASMDataTable asmData;
    @ObfuscationIgnore
    private ModContainer modContainer;

    @ObfuscationIgnore
    public FMLPreInitializationEvent(Object ... data) {
        super(data);
        this.asmData = (ASMDataTable)data[0];
        this.configurationDir = (File)data[1];
    }

    @Override
    @ObfuscationIgnore
    public LoaderState$ModState getModState() {
        return LoaderState$ModState.PREINITIALIZED;
    }

    @Override
    @ObfuscationIgnore
    public void applyModContainer(ModContainer activeContainer) {
        this.modContainer = activeContainer;
        this.modMetadata = activeContainer.getMetadata();
        this.sourceFile = activeContainer.getSource();
        this.suggestedConfigFile = new File(this.configurationDir, activeContainer.getModId() + ".cfg");
    }

    @ObfuscationIgnore
    public File getSourceFile() {
        return this.sourceFile;
    }

    @ObfuscationIgnore
    public ModMetadata getModMetadata() {
        return this.modMetadata;
    }

    @ObfuscationIgnore
    public File getModConfigurationDirectory() {
        return this.configurationDir;
    }

    @ObfuscationIgnore
    public File getSuggestedConfigurationFile() {
        return this.suggestedConfigFile;
    }

    @ObfuscationIgnore
    public ASMDataTable getAsmData() {
        return this.asmData;
    }

    @ObfuscationIgnore
    public Properties getVersionProperties() {
        if (this.modContainer instanceof FMLModContainer) {
            return ((FMLModContainer)this.modContainer).searchForVersionProperties();
        }
        return null;
    }

    @ObfuscationIgnore
    public Logger getModLog() {
        Logger logger = LogManager.getLogger((String)this.modContainer.getModId());
        return logger;
    }

    @Deprecated
    @ObfuscationIgnore
    public Certificate[] getFMLSigningCertificates() {
        CodeSource codeSource = this.getClass().getClassLoader().getParent().getClass().getProtectionDomain().getCodeSource();
        Certificate[] certificateArray = codeSource.getCertificates();
        if (certificateArray == null) {
            return new Certificate[0];
        }
        return certificateArray;
    }
}

