/*
 * Decompiled with CFR 0.152.
 */
package cpw.mods.fml.common.eventhandler;

import com.google.common.collect.Maps;
import cpw.mods.fml.common.ModContainer;
import cpw.mods.fml.common.eventhandler.ASMEventHandler$ASMClassLoader;
import cpw.mods.fml.common.eventhandler.Event;
import cpw.mods.fml.common.eventhandler.EventPriority;
import cpw.mods.fml.common.eventhandler.IEventListener;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import java.lang.reflect.Method;
import java.util.HashMap;
import modules.ru.amaz1ng.core.common.utils.annotations.ObfuscationIgnore;
import org.apache.logging.log4j.ThreadContext;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;

@ObfuscationIgnore
public class ASMEventHandler
implements IEventListener {
    @ObfuscationIgnore
    private static int IDs = 0;
    @ObfuscationIgnore
    private static final String HANDLER_DESC = Type.getInternalName(IEventListener.class);
    @ObfuscationIgnore
    private static final String HANDLER_FUNC_DESC = Type.getMethodDescriptor((Method)IEventListener.class.getDeclaredMethods()[0]);
    @ObfuscationIgnore
    private static final ASMEventHandler$ASMClassLoader LOADER = new ASMEventHandler$ASMClassLoader(null);
    @ObfuscationIgnore
    private static final HashMap<Method, Class<?>> cache = Maps.newHashMap();
    @ObfuscationIgnore
    private static final boolean GETCONTEXT = Boolean.parseBoolean(System.getProperty("fml.LogContext", "false"));
    @ObfuscationIgnore
    private final IEventListener handler;
    @ObfuscationIgnore
    private final SubscribeEvent subInfo;
    @ObfuscationIgnore
    private ModContainer owner;
    @ObfuscationIgnore
    private String readable;

    @ObfuscationIgnore
    public ASMEventHandler(Object target, Method method, ModContainer owner) {
        this.owner = owner;
        this.handler = (IEventListener)this.createWrapper(method).getConstructor(Object.class).newInstance(target);
        this.subInfo = method.getAnnotation(SubscribeEvent.class);
        this.readable = "ASM: " + target + " " + method.getName() + Type.getMethodDescriptor((Method)method);
    }

    @Override
    @ObfuscationIgnore
    public void invoke(Event event) {
        if (this.owner != null && GETCONTEXT) {
            ThreadContext.put((String)"mod", (String)this.owner.getName());
        } else if (GETCONTEXT) {
            ThreadContext.put((String)"mod", (String)"");
        }
        if (!(this.handler == null || event.isCancelable() && event.isCanceled() && !this.subInfo.receiveCanceled())) {
            this.handler.invoke(event);
        }
        if (GETCONTEXT) {
            ThreadContext.remove((String)"mod");
        }
    }

    @ObfuscationIgnore
    public EventPriority getPriority() {
        return this.subInfo.priority();
    }

    @ObfuscationIgnore
    public Class<?> createWrapper(Method callback) {
        if (cache.containsKey(callback)) {
            return cache.get(callback);
        }
        ClassWriter classWriter = new ClassWriter(0);
        String string = this.getUniqueName(callback);
        String string2 = string.replace('.', '/');
        String string3 = Type.getInternalName(callback.getDeclaringClass());
        String string4 = Type.getInternalName(callback.getParameterTypes()[0]);
        classWriter.visit(50, 33, string2, null, "java/lang/Object", new String[]{HANDLER_DESC});
        classWriter.visitSource(".dynamic", null);
        classWriter.visitField(1, "instance", "Ljava/lang/Object;", null, null).visitEnd();
        MethodVisitor methodVisitor = classWriter.visitMethod(1, "<init>", "(Ljava/lang/Object;)V", null, null);
        methodVisitor.visitCode();
        methodVisitor.visitVarInsn(25, 0);
        methodVisitor.visitMethodInsn(183, "java/lang/Object", "<init>", "()V", false);
        methodVisitor.visitVarInsn(25, 0);
        methodVisitor.visitVarInsn(25, 1);
        methodVisitor.visitFieldInsn(181, string2, "instance", "Ljava/lang/Object;");
        methodVisitor.visitInsn(177);
        methodVisitor.visitMaxs(2, 2);
        methodVisitor.visitEnd();
        methodVisitor = classWriter.visitMethod(1, "invoke", HANDLER_FUNC_DESC, null, null);
        methodVisitor.visitCode();
        methodVisitor.visitVarInsn(25, 0);
        methodVisitor.visitFieldInsn(180, string2, "instance", "Ljava/lang/Object;");
        methodVisitor.visitTypeInsn(192, string3);
        methodVisitor.visitVarInsn(25, 1);
        methodVisitor.visitTypeInsn(192, string4);
        methodVisitor.visitMethodInsn(182, string3, callback.getName(), Type.getMethodDescriptor((Method)callback), false);
        methodVisitor.visitInsn(177);
        methodVisitor.visitMaxs(2, 2);
        methodVisitor.visitEnd();
        classWriter.visitEnd();
        Class<?> clazz = LOADER.define(string, classWriter.toByteArray());
        cache.put(callback, clazz);
        return clazz;
    }

    @ObfuscationIgnore
    private String getUniqueName(Method callback) {
        return String.format("%s_%d_%s_%s_%s", this.getClass().getName(), IDs++, callback.getDeclaringClass().getSimpleName(), callback.getName(), callback.getParameterTypes()[0].getSimpleName());
    }

    @ObfuscationIgnore
    public String toString() {
        return this.readable;
    }
}

