/*
 * Decompiled with CFR 0.152.
 */
package cpw.mods.fml.common.network;

import cpw.mods.fml.common.FMLLog;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.network.internal.FMLProxyPacket;
import gnu.trove.map.hash.TByteObjectHashMap;
import gnu.trove.map.hash.TObjectByteHashMap;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.MessageToMessageCodec;
import io.netty.util.AttributeKey;
import java.lang.ref.WeakReference;
import java.util.List;
import modules.ru.amaz1ng.core.common.utils.annotations.ObfuscationIgnore;
import org.apache.logging.log4j.Level;

@ChannelHandler.Sharable
@ObfuscationIgnore
public abstract class FMLIndexedMessageToMessageCodec<A>
extends MessageToMessageCodec<FMLProxyPacket, A> {
    private TByteObjectHashMap<Class<? extends A>> discriminators = new TByteObjectHashMap();
    private TObjectByteHashMap<Class<? extends A>> types = new TObjectByteHashMap();
    public static final AttributeKey<ThreadLocal<WeakReference<FMLProxyPacket>>> INBOUNDPACKETTRACKER = new AttributeKey("fml:inboundpacket");

    public void handlerAdded(ChannelHandlerContext ctx) {
        super.handlerAdded(ctx);
        ctx.attr(INBOUNDPACKETTRACKER).set(new ThreadLocal());
    }

    public FMLIndexedMessageToMessageCodec<A> addDiscriminator(int discriminator, Class<? extends A> type) {
        this.discriminators.put((byte)discriminator, type);
        this.types.put(type, (byte)discriminator);
        return this;
    }

    public abstract void encodeInto(ChannelHandlerContext var1, A var2, ByteBuf var3);

    protected final void encode(ChannelHandlerContext ctx, A msg, List<Object> out) {
        FMLProxyPacket fMLProxyPacket;
        ByteBuf byteBuf = Unpooled.buffer();
        Class<?> clazz = msg.getClass();
        byte by = this.types.get(clazz);
        byteBuf.writeByte((int)by);
        this.encodeInto(ctx, msg, byteBuf);
        FMLProxyPacket fMLProxyPacket2 = new FMLProxyPacket(byteBuf.copy(), (String)ctx.channel().attr(NetworkRegistry.FML_CHANNEL).get());
        WeakReference weakReference = (WeakReference)((ThreadLocal)ctx.attr(INBOUNDPACKETTRACKER).get()).get();
        FMLProxyPacket fMLProxyPacket3 = fMLProxyPacket = weakReference == null ? null : (FMLProxyPacket)weakReference.get();
        if (fMLProxyPacket != null) {
            fMLProxyPacket2.setDispatcher(fMLProxyPacket.getDispatcher());
        }
        out.add(fMLProxyPacket2);
    }

    public abstract void decodeInto(ChannelHandlerContext var1, ByteBuf var2, A var3);

    protected final void decode(ChannelHandlerContext ctx, FMLProxyPacket msg, List<Object> out) {
        this.testMessageValidity(msg);
        ByteBuf byteBuf = msg.payload();
        byte by = byteBuf.readByte();
        Class clazz = (Class)this.discriminators.get(by);
        if (clazz == null) {
            throw new NullPointerException("Undefined message for discriminator " + by + " in channel " + msg.channel());
        }
        Object t = clazz.newInstance();
        ((ThreadLocal)ctx.attr(INBOUNDPACKETTRACKER).get()).set(new WeakReference<FMLProxyPacket>(msg));
        this.decodeInto(ctx, byteBuf.slice(), t);
        out.add(t);
    }

    protected void testMessageValidity(FMLProxyPacket msg) {
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        FMLLog.log(Level.ERROR, cause, "FMLIndexedMessageCodec exception caught", new Object[0]);
        super.exceptionCaught(ctx, cause);
    }
}

