/*
 * Decompiled with CFR 0.152.
 */
package cpw.mods.fml.common.network.handshake;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import cpw.mods.fml.common.network.ByteBufUtils;
import cpw.mods.fml.common.network.handshake.FMLHandshakeMessage;
import cpw.mods.fml.common.registry.GameData$GameDataSnapshot;
import io.netty.buffer.ByteBuf;
import java.util.Map;
import java.util.Set;

public class FMLHandshakeMessage$ModIdData
extends FMLHandshakeMessage {
    private Map<String, Integer> modIds;
    private Set<String> blockSubstitutions;
    private Set<String> itemSubstitutions;

    public FMLHandshakeMessage$ModIdData() {
    }

    public FMLHandshakeMessage$ModIdData(GameData$GameDataSnapshot snapshot) {
        this.modIds = snapshot.idMap;
        this.blockSubstitutions = snapshot.blockSubstitutions;
        this.itemSubstitutions = snapshot.itemSubstitutions;
    }

    @Override
    public void fromBytes(ByteBuf buffer) {
        int n;
        int n2 = ByteBufUtils.readVarInt(buffer, 3);
        this.modIds = Maps.newHashMap();
        this.blockSubstitutions = Sets.newHashSet();
        this.itemSubstitutions = Sets.newHashSet();
        for (n = 0; n < n2; ++n) {
            this.modIds.put(ByteBufUtils.readUTF8String(buffer), ByteBufUtils.readVarInt(buffer, 3));
        }
        if (!buffer.isReadable()) {
            return;
        }
        n2 = ByteBufUtils.readVarInt(buffer, 3);
        for (n = 0; n < n2; ++n) {
            this.blockSubstitutions.add(ByteBufUtils.readUTF8String(buffer));
        }
        n2 = ByteBufUtils.readVarInt(buffer, 3);
        for (n = 0; n < n2; ++n) {
            this.itemSubstitutions.add(ByteBufUtils.readUTF8String(buffer));
        }
    }

    @Override
    public void toBytes(ByteBuf buffer) {
        ByteBufUtils.writeVarInt(buffer, this.modIds.size(), 3);
        for (Map.Entry<String, Integer> object : this.modIds.entrySet()) {
            ByteBufUtils.writeUTF8String(buffer, object.getKey());
            ByteBufUtils.writeVarInt(buffer, object.getValue(), 3);
        }
        ByteBufUtils.writeVarInt(buffer, this.blockSubstitutions.size(), 3);
        for (String string : this.blockSubstitutions) {
            ByteBufUtils.writeUTF8String(buffer, string);
        }
        ByteBufUtils.writeVarInt(buffer, this.blockSubstitutions.size(), 3);
        for (String string : this.itemSubstitutions) {
            ByteBufUtils.writeUTF8String(buffer, string);
        }
    }

    public Map<String, Integer> dataList() {
        return this.modIds;
    }

    public Set<String> blockSubstitutions() {
        return this.blockSubstitutions;
    }

    public Set<String> itemSubstitutions() {
        return this.itemSubstitutions;
    }

    @Override
    public String toString(Class<? extends Enum<?>> side) {
        return super.toString(side) + ":" + this.modIds.size() + " mappings";
    }
}

