/*
 * Decompiled with CFR 0.152.
 */
package cpw.mods.fml.common.registry;

import com.google.common.base.Strings;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.ObjectArrays;
import com.google.common.collect.Sets;
import cpw.mods.fml.common.FMLLog;
import cpw.mods.fml.common.IFuelHandler;
import cpw.mods.fml.common.IWorldGenerator;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.LoaderException;
import cpw.mods.fml.common.LoaderState;
import cpw.mods.fml.common.registry.GameData;
import cpw.mods.fml.common.registry.GameRegistry$1;
import cpw.mods.fml.common.registry.GameRegistry$Type;
import cpw.mods.fml.common.registry.GameRegistry$UniqueIdentifier;
import fgm.IIIiIiIiiiIiiiiiIiiiiiiiIiiiiIiiiiiiIiiIiiiIIiiiiIiIiIiiIiiiiIII;
import fgm.IIiIIIiIIiiiIIIIiIIIIiIiIiIIIIIiIiIIIIIIIiIIIiiIIIiiiiIIiIIIIIiI;
import fgm.IiIIIIiiiIiiIIiiIIiiiIIIIiIiiIiIiiiiiiiiiiIIIiiiiIiiIiIiIiiIIIII;
import fgm.IiIIIiIiIIiIiiiiiiIIiiiiIIiiiIIIiiIIIIiiIIiIiiiIIiIiIIIIIiIiiIii;
import fgm.IiIiIiiIiiiiiIIiIiIiIiIiiiIIIiiIiIIIIiiiiiIiIIiIIiIiIIIiiiiIIIiI;
import fgm.IiiiIIiIiIiiIiiIIIIiiiIIIiIiiiiiiIiiIiIIiIiIIiiIiiiIiiiIIIIiIiii;
import fgm.iIIIIiIiiIIIIiiIIiIiiIIIIIiIIiiiIIiiiIIiiiiiIiiiiIIiiIIIiIiIIIii;
import fgm.iIIiIIiiIiiIiIIIiIiIIIiIiiIIiIiIIiiiIIiiIiiiIiIIIiIiIiiIiiiIiIiI;
import fgm.iIIiiIiiIiIiIIiiiIIIIIiIIIIiIIIIiIiiiIIiiIiiiiIIIiIIIIiIIIiIIiiI;
import fgm.iiIIIIIIIiiiiiIiIiIiiIiiiiIIiiiiIIIIIIIIIIIiIIIiIiIiiiIiIIiiIiii;
import fgm.iiIIiiIiiIiiIiIIiiIIIiIiiiiIiiiiIIiIiIiiiIiIiiiIiiiIIIiIIiIiiiii;
import fgm.iiIiIiIiIIIiiiiIIIIiIiiIIiIIiIiIiIiIiIiIIiiiIIIIIIIIiiIiIiIIiiiI;
import fgm.iiiIIiiiiiIIiiIIiIiiIIiIIiIIIIiiiIiiiIiiIIiIIIiiIIiiiiiIIiIiiIII;
import fgm.iiiIiIIiiIiIiiIiIiIiIIiIiIiIIIIiIiIiiIIiIiiiiIiIIiiiIiiiiIIiIiiI;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import modules.ru.amaz1ng.core.common.utils.annotations.ObfuscationIgnore;
import org.apache.logging.log4j.Level;

@ObfuscationIgnore
public class GameRegistry {
    private static Set<IWorldGenerator> worldGenerators = Sets.newHashSet();
    private static Map<IWorldGenerator, Integer> worldGeneratorIndex = Maps.newHashMap();
    private static List<IFuelHandler> fuelHandlers = Lists.newArrayList();
    private static List<IWorldGenerator> sortedGeneratorList;

    public static void registerWorldGenerator(IWorldGenerator generator, int modGenerationWeight) {
        worldGenerators.add(generator);
        worldGeneratorIndex.put(generator, modGenerationWeight);
        if (sortedGeneratorList != null) {
            sortedGeneratorList = null;
        }
    }

    public static void generateWorld(int chunkX, int chunkZ, iIIiiIiiIiIiIIiiiIIIIIiIIIIiIIIIiIiiiIIiiIiiiiIIIiIIIIiIIIiIIiiI world, iiiIIiiiiiIIiiIIiIiiIIiIIiIIIIiiiIiiiIiiIIiIIIiiIIiiiiiIIiIiiIII chunkGenerator, iiiIIiiiiiIIiiIIiIiiIIiIIiIIIIiiiIiiiIiiIIiIIIiiIIiiiiiIIiIiiIII chunkProvider) {
        if (sortedGeneratorList == null) {
            GameRegistry.computeSortedGeneratorList();
        }
        long l = world.IIiIIIIiiiiiiiIIiiiiiiiiiiiIIIIIiIIIIiIiiiiIiIiIIiiIiiIiiIiIiiIi();
        Random random = new Random(l);
        long l2 = random.nextLong() >> 3;
        long l3 = random.nextLong() >> 3;
        long l4 = l2 * (long)chunkX + l3 * (long)chunkZ ^ l;
        for (IWorldGenerator iWorldGenerator : sortedGeneratorList) {
            random.setSeed(l4);
            iWorldGenerator.generate(random, chunkX, chunkZ, world, chunkGenerator, chunkProvider);
        }
    }

    private static void computeSortedGeneratorList() {
        ArrayList arrayList = Lists.newArrayList(worldGenerators);
        Collections.sort(arrayList, new GameRegistry$1());
        sortedGeneratorList = ImmutableList.copyOf((Collection)arrayList);
    }

    public static void registerItem(IIiIIIiIIiiiIIIIiIIIIiIiIiIIIIIiIiIIIIIIIiIIIiiIIIiiiiIIiIIIIIiI item, String name) {
        GameRegistry.registerItem(item, name, null);
    }

    public static void registerID(IIiIIIiIIiiiIIIIiIIIIiIiIiIIIIIiIiIIIIIIIiIIIiiIIIiiiiIIiIIIIIiI item, String name, int id) {
        GameData.getMain().register(item, name, id);
    }

    public static void registerIDBlock(iiIIIIIIIiiiiiIiIiIiiIiiiiIIiiiiIIIIIIIIIIIiIIIiIiIiiiIiIIiiIiii item, String name, int id) {
        GameData.getMain().register(item, name, id);
    }

    public static IIiIIIiIIiiiIIIIiIIIIiIiIiIIIIIiIiIIIIIIIiIIIiiIIIiiiiIIiIIIIIiI registerItem(IIiIIIiIIiiiIIIIiIIIIiIiIiIIIIIiIiIIIIIIIiIIIiiIIIiiiiIIiIIIIIiI item, String name, String modId) {
        GameData.getMain().registerItem(item, name);
        return item;
    }

    public static void addSubstitutionAlias(String nameToSubstitute, GameRegistry$Type type, Object object) {
        GameData.getMain().registerSubstitutionAlias(nameToSubstitute, type, object);
    }

    public static iiIIIIIIIiiiiiIiIiIiiIiiiiIIiiiiIIIIIIIIIIIiIIIiIiIiiiIiIIiiIiii registerBlock(iiIIIIIIIiiiiiIiIiIiiIiiiiIIiiiiIIIIIIIIIIIiIIIiIiIiiiIiIIiiIiii block, String name) {
        return GameRegistry.registerBlock(block, IiIiIiiIiiiiiIIiIiIiIiIiiiIIIiiIiIIIIiiiiiIiIIiIIiIiIIIiiiiIIIiI.class, name);
    }

    public static iiIIIIIIIiiiiiIiIiIiiIiiiiIIiiiiIIIIIIIIIIIiIIIiIiIiiiIiIIiiIiii registerBlock(iiIIIIIIIiiiiiIiIiIiiIiiiiIIiiiiIIIIIIIIIIIiIIIiIiIiiiIiIIiiIiii block, Class<? extends IiIiIiiIiiiiiIIiIiIiIiIiiiIIIiiIiIIIIiiiiiIiIIiIIiIiIIIiiiiIIIiI> itemclass, String name) {
        return GameRegistry.registerBlock(block, itemclass, name, new Object[0]);
    }

    public static iiIIIIIIIiiiiiIiIiIiiIiiiiIIiiiiIIIIIIIIIIIiIIIiIiIiiiIiIIiiIiii registerBlockID(iiIIIIIIIiiiiiIiIiIiiIiiiiIIiiiiIIIIIIIIIIIiIIIiIiIiiiIiIIiiIiii block, Class<? extends IiIiIiiIiiiiiIIiIiIiIiIiiiIIIiiIiIIIIiiiiiIiIIiIIiIiIIIiiiiIIIiI> itemclass, String name, int id) {
        return GameRegistry.registerBlockID(block, itemclass, name, id, new Object[0]);
    }

    @Deprecated
    public static iiIIIIIIIiiiiiIiIiIiiIiiiiIIiiiiIIIIIIIIIIIiIIIiIiIiiiIiIIiiIiii registerBlock(iiIIIIIIIiiiiiIiIiIiiIiiiiIIiiiiIIIIIIIIIIIiIIIiIiIiiiIiIIiiIiii block, Class<? extends IiIiIiiIiiiiiIIiIiIiIiIiiiIIIiiIiIIIIiiiiiIiIIiIIiIiIIIiiiiIIIiI> itemclass, String name, String modId, Object ... itemCtorArgs) {
        return GameRegistry.registerBlock(block, itemclass, name, itemCtorArgs);
    }

    public static iiIIIIIIIiiiiiIiIiIiiIiiiiIIiiiiIIIIIIIIIIIiIIIiIiIiiiIiIIiiIiii registerBlockID(iiIIIIIIIiiiiiIiIiIiiIiiiiIIiiiiIIIIIIIIIIIiIIIiIiIiiiIiIIiiIiii block, Class<? extends IiIiIiiIiiiiiIIiIiIiIiIiiiIIIiiIiIIIIiiiiiIiIIiIIiIiIIIiiiiIIIiI> itemclass, String name, int id, Object ... itemCtorArgs) {
        if (Loader.instance().isInState(LoaderState.CONSTRUCTING)) {
            FMLLog.warning("The mod %s is attempting to register a block whilst it it being constructed. This is bad modding practice - please use a proper mod lifecycle event.", Loader.instance().activeModContainer());
        }
        try {
            assert (block != null) : "registerBlock: block cannot be null";
            IiIiIiiIiiiiiIIiIiIiIiIiiiIIIiiIiIIIIiiiiiIiIIiIIiIiIIIiiiiIIIiI iiIiIiiIiiiiiIIiIiIiIiIiiiIIIiiIiIIIIiiiiiIiIIiIIiIiIIIiiiiIIIiI = null;
            if (itemclass != null) {
                Class[] classArray = new Class[itemCtorArgs.length + 1];
                classArray[0] = iiIIIIIIIiiiiiIiIiIiiIiiiiIIiiiiIIIIIIIIIIIiIIIiIiIiiiIiIIiiIiii.class;
                for (int i = 1; i < classArray.length; ++i) {
                    classArray[i] = itemCtorArgs[i - 1].getClass();
                }
                Constructor<? extends IiIiIiiIiiiiiIIiIiIiIiIiiiIIIiiIiIIIIiiiiiIiIIiIIiIiIIIiiiiIIIiI> constructor = itemclass.getConstructor(classArray);
                iiIiIiiIiiiiiIIiIiIiIiIiiiIIIiiIiIIIIiiiiiIiIIiIIiIiIIIiiiiIIIiI = constructor.newInstance(ObjectArrays.concat((Object)block, (Object[])itemCtorArgs));
            }
            GameData.getMain().registerBlockID(block, name, id);
            if (iiIiIiiIiiiiiIIiIiIiIiIiiiIIIiiIiIIIIiiiiiIiIIiIIiIiIIIiiiiIIIiI != null) {
                GameData.getMain().registerItem(iiIiIiiIiiiiiIIiIiIiIiIiiiIIIiiIiIIIIiiiiiIiIIiIIiIiIIIiiiiIIIiI, name);
            }
            return block;
        }
        catch (Exception exception) {
            FMLLog.log(Level.ERROR, exception, "Caught an exception during block registration", new Object[0]);
            throw new LoaderException(exception);
        }
    }

    public static iiIIIIIIIiiiiiIiIiIiiIiiiiIIiiiiIIIIIIIIIIIiIIIiIiIiiiIiIIiiIiii registerBlock(iiIIIIIIIiiiiiIiIiIiiIiiiiIIiiiiIIIIIIIIIIIiIIIiIiIiiiIiIIiiIiii block, Class<? extends IiIiIiiIiiiiiIIiIiIiIiIiiiIIIiiIiIIIIiiiiiIiIIiIIiIiIIIiiiiIIIiI> itemclass, String name, Object ... itemCtorArgs) {
        if (Loader.instance().isInState(LoaderState.CONSTRUCTING)) {
            FMLLog.warning("The mod %s is attempting to register a block whilst it it being constructed. This is bad modding practice - please use a proper mod lifecycle event.", Loader.instance().activeModContainer());
        }
        try {
            assert (block != null) : "registerBlock: block cannot be null";
            IiIiIiiIiiiiiIIiIiIiIiIiiiIIIiiIiIIIIiiiiiIiIIiIIiIiIIIiiiiIIIiI iiIiIiiIiiiiiIIiIiIiIiIiiiIIIiiIiIIIIiiiiiIiIIiIIiIiIIIiiiiIIIiI = null;
            if (itemclass != null) {
                Class[] classArray = new Class[itemCtorArgs.length + 1];
                classArray[0] = iiIIIIIIIiiiiiIiIiIiiIiiiiIIiiiiIIIIIIIIIIIiIIIiIiIiiiIiIIiiIiii.class;
                for (int i = 1; i < classArray.length; ++i) {
                    classArray[i] = itemCtorArgs[i - 1].getClass();
                }
                Constructor<? extends IiIiIiiIiiiiiIIiIiIiIiIiiiIIIiiIiIIIIiiiiiIiIIiIIiIiIIIiiiiIIIiI> constructor = itemclass.getConstructor(classArray);
                iiIiIiiIiiiiiIIiIiIiIiIiiiIIIiiIiIIIIiiiiiIiIIiIIiIiIIIiiiiIIIiI = constructor.newInstance(ObjectArrays.concat((Object)block, (Object[])itemCtorArgs));
            }
            GameData.getMain().registerBlock(block, name);
            if (iiIiIiiIiiiiiIIiIiIiIiIiiiIIIiiIiIIIIiiiiiIiIIiIIiIiIIIiiiiIIIiI != null) {
                GameData.getMain().registerItem(iiIiIiiIiiiiiIIiIiIiIiIiiiIIIiiIiIIIIiiiiiIiIIiIIiIiIIIiiiiIIIiI, name);
            }
            return block;
        }
        catch (Exception exception) {
            FMLLog.log(Level.ERROR, exception, "Caught an exception during block registration", new Object[0]);
            throw new LoaderException(exception);
        }
    }

    public static void addRecipe(iIIIIiIiiIIIIiiIIiIiiIIIIIiIIiiiIIiiiIIiiiiiIiiiiIIiiIIIiIiIIIii output, Object ... params) {
        GameRegistry.addShapedRecipe(output, params);
    }

    public static iiIIiiIiiIiiIiIIiiIIIiIiiiiIiiiiIIiIiIiiiIiIiiiIiiiIIIiIIiIiiiii addShapedRecipe(iIIIIiIiiIIIIiiIIiIiiIIIIIiIIiiiIIiiiIIiiiiiIiiiiIIiiIIIiIiIIIii output, Object ... params) {
        return IiiiIIiIiIiiIiiIIIIiiiIIIiIiiiiiiIiiIiIIiIiIIiiIiiiIiiiIIIIiIiii.IiiIIiIiIIiiIIIiiIiIiiiIIIIiiiiIiIiIiIIIIIiiIIIiiiIIiIIiIIIIiiii().IiiIIiIiIIiiIIIiiIiIiiiIIIIiiiiIiIiIiIIIIIiiIIIiiiIIiIIiIIIIiiii(output, params);
    }

    public static void addShapelessRecipe(iIIIIiIiiIIIIiiIIiIiiIIIIIiIIiiiIIiiiIIiiiiiIiiiiIIiiIIIiIiIIIii output, Object ... params) {
        IiiiIIiIiIiiIiiIIIIiiiIIIiIiiiiiiIiiIiIIiIiIIiiIiiiIiiiIIIIiIiii.IiiIIiIiIIiiIIIiiIiIiiiIIIIiiiiIiIiIiIIIIIiiIIIiiiIIiIIiIIIIiiii().iIiIIIIiIiiIIiIIIiIiiIIiiIiIIIIIIiiIIIIiiIIIiiIIiIIiiiIiIIiIIiiI(output, params);
    }

    public static void addRecipe(iiIIiiIiiIiiIiIIiiIIIiIiiiiIiiiiIIiIiIiiiIiIiiiIiiiIIIiIIiIiiiii recipe) {
        IiiiIIiIiIiiIiiIIIIiiiIIIiIiiiiiiIiiIiIIiIiIIiiIiiiIiiiIIIIiIiii.IiiIIiIiIIiiIIIiiIiIiiiIIIIiiiiIiIiIiIIIIIiiIIIiiiIIiIIiIIIIiiii().iIiIIIIiIiiIIiIIIiIiiIIiiIiIIIIIIiiIIIIiiIIIiiIIiIIiiiIiIIiIIiiI().add(recipe);
    }

    public static void addSmelting(iiIIIIIIIiiiiiIiIiIiiIiiiiIIiiiiIIIIIIIIIIIiIIIiIiIiiiIiIIiiIiii input, iIIIIiIiiIIIIiiIIiIiiIIIIIiIIiiiIIiiiIIiiiiiIiiiiIIiiIIIiIiIIIii output, float xp) {
        IIIiIiIiiiIiiiiiIiiiiiiiIiiiiIiiiiiiIiiIiiiIIiiiiIiIiIiiIiiiiIII.IiiIIiIiIIiiIIIiiIiIiiiIIIIiiiiIiIiIiIIIIIiiIIIiiiIIiIIiIIIIiiii().IiiIIiIiIIiiIIIiiIiIiiiIIIIiiiiIiIiIiIIIIIiiIIIiiiIIiIIiIIIIiiii(input, output, xp);
    }

    public static void addSmelting(IIiIIIiIIiiiIIIIiIIIIiIiIiIIIIIiIiIIIIIIIiIIIiiIIIiiiiIIiIIIIIiI input, iIIIIiIiiIIIIiiIIiIiiIIIIIiIIiiiIIiiiIIiiiiiIiiiiIIiiIIIiIiIIIii output, float xp) {
        IIIiIiIiiiIiiiiiIiiiiiiiIiiiiIiiiiiiIiiIiiiIIiiiiIiIiIiiIiiiiIII.IiiIIiIiIIiiIIIiiIiIiiiIIIIiiiiIiIiIiIIIIIiiIIIiiiIIiIIiIIIIiiii().IiiIIiIiIIiiIIIiiIiIiiiIIIIiiiiIiIiIiIIIIIiiIIIiiiIIiIIiIIIIiiii(input, output, xp);
    }

    public static void addSmelting(iIIIIiIiiIIIIiiIIiIiiIIIIIiIIiiiIIiiiIIiiiiiIiiiiIIiiIIIiIiIIIii input, iIIIIiIiiIIIIiiIIiIiiIIIIIiIIiiiIIiiiIIiiiiiIiiiiIIiiIIIiIiIIIii output, float xp) {
        IIIiIiIiiiIiiiiiIiiiiiiiIiiiiIiiiiiiIiiIiiiIIiiiiIiIiIiiIiiiiIII.IiiIIiIiIIiiIIIiiIiIiiiIIIIiiiiIiIiIiIIIIIiiIIIiiiIIiIIiIIIIiiii().IiiIIiIiIIiiIIIiiIiIiiiIIIIiiiiIiIiIiIIIIIiiIIIiiiIIiIIiIIIIiiii(input, output, xp);
    }

    public static void registerTileEntity(Class<? extends iiIiIiIiIIIiiiiIIIIiIiiIIiIIiIiIiIiIiIiIIiiiIIIIIIIIiiIiIiIIiiiI> tileEntityClass, String id) {
        iiIiIiIiIIIiiiiIIIIiIiiIIiIIiIiIiIiIiIiIIiiiIIIIIIIIiiIiIiIIiiiI.IiiIIiIiIIiiIIIiiIiIiiiIIIIiiiiIiIiIiIIIIIiiIIIiiiIIiIIiIIIIiiii(tileEntityClass, id);
    }

    public static void registerTileEntityWithAlternatives(Class<? extends iiIiIiIiIIIiiiiIIIIiIiiIIiIIiIiIiIiIiIiIIiiiIIIIIIIIiiIiIiIIiiiI> tileEntityClass, String id, String ... alternatives) {
    }

    public static void registerFuelHandler(IFuelHandler handler) {
        fuelHandlers.add(handler);
    }

    public static int getFuelValue(iIIIIiIiiIIIIiiIIiIiiIIIIIiIIiiiIIiiiIIiiiiiIiiiiIIiiIIIiIiIIIii itemStack) {
        int n = 0;
        for (IFuelHandler iFuelHandler : fuelHandlers) {
            n = Math.max(n, iFuelHandler.getBurnTime(itemStack));
        }
        return n;
    }

    public static iiIIIIIIIiiiiiIiIiIiiIiiiiIIiiiiIIIIIIIIIIIiIIIiIiIiiiIiIIiiIiii findBlock(String modId, String name) {
        return GameData.findBlock(modId, name);
    }

    public static IIiIIIiIIiiiIIIIiIIIIiIiIiIIIIIiIiIIIIIIIiIIIiiIIIiiiiIIiIIIIIiI findItem(String modId, String name) {
        return GameData.findItem(modId, name);
    }

    public static void registerCustomItemStack(String name, iIIIIiIiiIIIIiiIIiIiiIIIIIiIIiiiIIiiiIIiiiiiIiiiiIIiiIIIiIiIIIii itemStack) {
        GameData.registerCustomItemStack(name, itemStack);
    }

    public static iIIIIiIiiIIIIiiIIiIiiIIIIIiIIiiiIIiiiIIiiiiiIiiiiIIiiIIIiIiIIIii findItemStack(String modId, String name, int stackSize) {
        iIIIIiIiiIIIIiiIIiIiiIIIIIiIIiiiIIiiiIIiiiiiIiiiiIIiiIIIiIiIIIii iIIIIiIiiIIIIiiIIiIiiIIIIIiIIiiiIIiiiIIiiiiiIiiiiIIiiIIIiIiIIIii2 = GameData.findItemStack(modId, name);
        if (iIIIIiIiiIIIIiiIIiIiiIIIIIiIIiiiIIiiiIIiiiiiIiiiiIIiiIIIiIiIIIii2 != null) {
            iIIIIiIiiIIIIiiIIiIiiIIIIIiIIiiiIIiiiIIiiiiiIiiiiIIiiIIIiIiIIIii iIIIIiIiiIIIIiiIIiIiiIIIIIiIIiiiIIiiiIIiiiiiIiiiiIIiiIIIiIiIIIii3 = iIIIIiIiiIIIIiiIIiIiiIIIIIiIIiiiIIiiiIIiiiiiIiiiiIIiiIIIiIiIIIii2.iIIiiIiIiIIIiiIiiIiIiIiIIiIIiIIIIIIiiIIiiiiIiiiIiIiiiiIIiIIIIIii();
            iIIIIiIiiIIIIiiIIiIiiIIIIIiIIiiiIIiiiIIiiiiiIiiiiIIiiIIIiIiIIIii3.iIiIIIIiIiiIIiIIIiIiiIIiiIiIIIIIIiiIIIIiiIIIiiIIiIIiiiIiIIiIIiiI = Math.min(stackSize, iIIIIiIiiIIIIiiIIiIiiIIIIIiIIiiiIIiiiIIiiiiiIiiiiIIiiIIIiIiIIIii3.iiiiIiIiIIIiiIIiiIIIIiiiIiiIIiIIiiiIIiIiIIiiiiiIiiIIIiIIIiiiiIII());
            return iIIIIiIiiIIIIiiIIiIiiIIIIIiIIiiiIIiiiIIiiiiiIiiiiIIiiIIIiIiIIIii3;
        }
        return null;
    }

    public static GameRegistry$UniqueIdentifier findUniqueIdentifierFor(iiIIIIIIIiiiiiIiIiIiiIiiiiIIiiiiIIIIIIIIIIIiIIIiIiIiiiIiIIiiIiii block) {
        return GameData.getUniqueName(block);
    }

    public static GameRegistry$UniqueIdentifier findUniqueIdentifierFor(IIiIIIiIIiiiIIIIiIIIIiIiIiIIIIIiIiIIIIIIIiIIIiiIIIiiiiIIiIIIIIiI item) {
        return GameData.getUniqueName(item);
    }

    public static iIIIIiIiiIIIIiiIIiIiiIIIIIiIIiiiIIiiiIIiiiiiIiiiiIIiiIIIiIiIIIii makeItemStack(String itemName, int meta, int stackSize, String nbtString) {
        if (itemName == null) {
            throw new IllegalArgumentException("The itemName cannot be null");
        }
        IIiIIIiIIiiiIIIIiIIIIiIiIiIIIIIiIiIIIIIIIiIIIiiIIIiiiiIIiIIIIIiI iIiIIIiIIiiiIIIIiIIIIiIiIiIIIIIiIiIIIIIIIiIIIiiIIIiiiiIIiIIIIIiI = GameData.getItemRegistry().getObject(itemName);
        if (iIiIIIiIIiiiIIIIiIIIIiIiIiIIIIIiIiIIIIIIIiIIIiiIIIiiiiIIiIIIIIiI == null) {
            FMLLog.getLogger().log(Level.TRACE, "Unable to find item with name {}", (Object)itemName);
            return null;
        }
        iIIIIiIiiIIIIiiIIiIiiIIIIIiIIiiiIIiiiIIiiiiiIiiiiIIiiIIIiIiIIIii iIIIIiIiiIIIIiiIIiIiiIIIIIiIIiiiIIiiiIIiiiiiIiiiiIIiiIIIiIiIIIii2 = new iIIIIiIiiIIIIiiIIiIiiIIIIIiIIiiiIIiiiIIiiiiiIiiiiIIiiIIIiIiIIIii(iIiIIIiIIiiiIIIIiIIIIiIiIiIIIIIiIiIIIIIIIiIIIiiIIIiiiiIIiIIIIIiI, 1, meta);
        if (!Strings.isNullOrEmpty((String)nbtString)) {
            IiIIIiIiIIiIiiiiiiIIiiiiIIiiiIIIiiIIIIiiIIiIiiiIIiIiIIIIIiIiiIii iiIIIiIiIIiIiiiiiiIIiiiiIIiiiIIIiiIIIIiiIIiIiiiIIiIiIIIIIiIiiIii = null;
            try {
                iiIIIiIiIIiIiiiiiiIIiiiiIIiiiIIIiiIIIIiiIIiIiiiIIiIiIIIIIiIiiIii = IiIIIIiiiIiiIIiiIIiiiIIIIiIiiIiIiiiiiiiiiiIIIiiiiIiiIiIiIiiIIIII.IiiIIiIiIIiiIIIiiIiIiiiIIIIiiiiIiIiIiIIIIIiiIIIiiiIIiIIiIIIIiiii(nbtString);
            }
            catch (iIIiIIiiIiiIiIIIiIiIIIiIiiIIiIiIIiiiIIiiIiiiIiIIIiIiIiiIiiiIiIiI iIIiIIiiIiiIiIIIiIiIIIiIiiIIiIiIIiiiIIiiIiiiIiIIIiIiIiiIiiiIiIiI2) {
                FMLLog.getLogger().log(Level.WARN, "Encountered an exception parsing ItemStack NBT string {}", (Object)nbtString, (Object)iIIiIIiiIiiIiIIIiIiIIIiIiiIIiIiIIiiiIIiiIiiiIiIIIiIiIiiIiiiIiIiI2);
                throw Throwables.propagate((Throwable)iIIiIIiiIiiIiIIIiIiIIIiIiiIIiIiIIiiiIIiiIiiiIiIIIiIiIiiIiiiIiIiI2);
            }
            if (!(iiIIIiIiIIiIiiiiiiIIiiiiIIiiiIIIiiIIIIiiIIiIiiiIIiIiIIIIIiIiiIii instanceof iiiIiIIiiIiIiiIiIiIiIIiIiIiIIIIiIiIiiIIiIiiiiIiIIiiiIiiiiIIiIiiI)) {
                FMLLog.getLogger().log(Level.WARN, "Unexpected NBT string - multiple values {}", (Object)nbtString);
                throw new RuntimeException("Invalid NBT JSON");
            }
            iIIIIiIiiIIIIiiIIiIiiIIIIIiIIiiiIIiiiIIiiiiiIiiiiIIiiIIIiIiIIIii2.IIIiIIiiiIiIIIiiiIIIiiIiIIIiiiIIIiIIIIiiiIiiiiiiIiiiiiIiiiIiiIII((iiiIiIIiiIiIiiIiIiIiIIiIiIiIIIIiIiIiiIIiIiiiiIiIIiiiIiiiiIIiIiiI)iiIIIiIiIIiIiiiiiiIIiiiiIIiiiIIIiiIIIIiiIIiIiiiIIiIiIIIIIiIiiIii);
        }
        return iIIIIiIiiIIIIiiIIiIiiIIIIIiIIiiiIIiiiIIiiiiiIiiiiIIiiIIIiIiIIIii2;
    }

    static /* synthetic */ Map access$000() {
        return worldGeneratorIndex;
    }
}

