/*
 * Decompiled with CFR 0.152.
 */
package cpw.mods.fml.common.registry;

import com.google.common.base.Throwables;
import cpw.mods.fml.common.FMLLog;
import cpw.mods.fml.common.registry.GameData;
import fgm.IIiIIIiIIiiiIIIIiIIIIiIiIiIIIIIiIiIIIIIIIiIIIiiIIIiiiiIIiIIIIIiI;
import fgm.iiIIIIIIIiiiiiIiIiIiiIiiiiIIiiiiIIIIIIIIIIIiIIIiIiIiiiIiIIiiIiii;
import fgm.iiIIIIIiIIiIIiiiIIIiIiIiiiiiiIiiIIiiiIIIiiiiiiiIIiiiiiIiIIIiiIII;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import org.apache.logging.log4j.Level;

class ObjectHolderRef {
    private Field field;
    private String injectedObject;
    private boolean isBlock;
    private boolean isItem;
    private static Field modifiersField;
    private static Object reflectionFactory;
    private static Method newFieldAccessor;
    private static Method fieldAccessorSet;

    ObjectHolderRef(Field field, String injectedObject, boolean extractFromExistingValues) {
        this.field = field;
        this.isBlock = iiIIIIIIIiiiiiIiIiIiiIiiiiIIiiiiIIIIIIIIIIIiIIIiIiIiiiIiIIiiIiii.class.isAssignableFrom(field.getType());
        this.isItem = IIiIIIiIIiiiIIIIiIIIIiIiIiIIIIIiIiIIIIIIIiIIIiiIIIiiiiIIiIIIIIiI.class.isAssignableFrom(field.getType());
        if (extractFromExistingValues) {
            try {
                Object object = field.get(null);
                if (object == null || object == GameData.getBlockRegistry().getDefaultValue()) {
                    this.injectedObject = null;
                    this.field = null;
                    this.isBlock = false;
                    this.isItem = false;
                    return;
                }
                this.injectedObject = this.isBlock ? GameData.getBlockRegistry().getNameForObject(object) : (this.isItem ? GameData.getItemRegistry().getNameForObject(object) : null);
            }
            catch (Exception exception) {
                throw Throwables.propagate((Throwable)exception);
            }
        } else {
            this.injectedObject = injectedObject;
        }
        if (this.injectedObject == null || !this.isValid()) {
            throw new IllegalStateException(String.format("The ObjectHolder annotation cannot apply to a field that is not an Item or Block (found : %s at %s.%s)", field.getType().getName(), field.getClass().getName(), field.getName()));
        }
        ObjectHolderRef.makeWritable(field);
    }

    private static void makeWritable(Field f) {
        try {
            if (modifiersField == null) {
                Method method = Class.forName("sun.reflect.ReflectionFactory").getDeclaredMethod("getReflectionFactory", new Class[0]);
                reflectionFactory = method.invoke(null, new Object[0]);
                newFieldAccessor = Class.forName("sun.reflect.ReflectionFactory").getDeclaredMethod("newFieldAccessor", Field.class, Boolean.TYPE);
                fieldAccessorSet = Class.forName("sun.reflect.FieldAccessor").getDeclaredMethod("set", Object.class, Object.class);
                modifiersField = Field.class.getDeclaredField("modifiers");
                modifiersField.setAccessible(true);
            }
            modifiersField.setInt(f, f.getModifiers() & 0xFFFFFFEF);
        }
        catch (Exception exception) {
            throw Throwables.propagate((Throwable)exception);
        }
    }

    public boolean isValid() {
        return this.isBlock || this.isItem;
    }

    public void apply() {
        Object object;
        if (this.isBlock) {
            object = GameData.getBlockRegistry().getObject(this.injectedObject);
            if (object == iiIIIIIiIIiIIiiiIIIiIiIiiiiiiIiiIIiiiIIIiiiiiiiIIiiiiiIiIIIiiIII.IiiIIiIiIIiiIIIiiIiIiiiIIIIiiiiIiIiIiIIIIIiiIIIiiiIIiIIiIIIIiiii) {
                object = null;
            }
        } else {
            object = this.isItem ? GameData.getItemRegistry().getObject(this.injectedObject) : null;
        }
        if (object == null) {
            FMLLog.getLogger().log(Level.DEBUG, "Unable to lookup {} for {}. This means the object wasn't registered. It's likely just mod options.", (Object)this.injectedObject, (Object)this.field);
            return;
        }
        try {
            Object object2 = newFieldAccessor.invoke(reflectionFactory, this.field, false);
            fieldAccessorSet.invoke(object2, null, object);
        }
        catch (Exception exception) {
            FMLLog.log(Level.WARN, exception, "Unable to set %s with value %s (%s)", this.field, object, this.injectedObject);
        }
    }
}

