/*
 * Decompiled with CFR 0.152.
 */
package cpw.mods.fml.common.versioning;

import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import cpw.mods.fml.common.FMLLog;
import cpw.mods.fml.common.LoaderException;
import cpw.mods.fml.common.versioning.ArtifactVersion;
import cpw.mods.fml.common.versioning.DefaultArtifactVersion;
import cpw.mods.fml.common.versioning.InvalidVersionSpecificationException;
import cpw.mods.fml.common.versioning.VersionRange;
import java.util.ArrayList;
import modules.ru.amaz1ng.core.common.utils.annotations.ObfuscationIgnore;
import org.apache.logging.log4j.Level;

@ObfuscationIgnore
public class VersionParser {
    private static final Splitter SEPARATOR = Splitter.on((char)'@').omitEmptyStrings().trimResults();

    public static ArtifactVersion parseVersionReference(String labelledRef) {
        if (Strings.isNullOrEmpty((String)labelledRef)) {
            throw new RuntimeException(String.format("Empty reference %s", labelledRef));
        }
        ArrayList arrayList = Lists.newArrayList((Iterable)SEPARATOR.split((CharSequence)labelledRef));
        if (arrayList.size() > 2) {
            throw new RuntimeException(String.format("Invalid versioned reference %s", labelledRef));
        }
        if (arrayList.size() == 1) {
            return new DefaultArtifactVersion((String)arrayList.get(0), true);
        }
        return new DefaultArtifactVersion((String)arrayList.get(0), VersionParser.parseRange((String)arrayList.get(1)));
    }

    public static boolean satisfies(ArtifactVersion target, ArtifactVersion source) {
        return target.containsVersion(source);
    }

    public static VersionRange parseRange(String range) {
        try {
            return VersionRange.createFromVersionSpec(range);
        }
        catch (InvalidVersionSpecificationException invalidVersionSpecificationException) {
            FMLLog.log(Level.ERROR, invalidVersionSpecificationException, "Unable to parse a version range specification successfully %s", range);
            throw new LoaderException(invalidVersionSpecificationException);
        }
    }
}

