/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl;

import java.lang.reflect.Field;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import java.nio.ShortBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;
import org.lwjgl.BufferUtils;
import org.lwjgl.LWJGLUtil;
import org.lwjgl.MemoryUtil$Accessor;
import org.lwjgl.MemoryUtil$AccessorJNI;
import org.lwjgl.MemoryUtil$AccessorReflect;
import org.lwjgl.MemoryUtil$CharSequenceNT;
import org.lwjgl.PointerBuffer;

public final class MemoryUtil {
    private static final Charset ascii;
    private static final Charset utf8;
    private static final Charset utf16;
    private static final MemoryUtil$Accessor memUtil;

    private MemoryUtil() {
    }

    public static long getAddress0(Buffer buffer) {
        return memUtil.getAddress(buffer);
    }

    public static long getAddress0Safe(Buffer buffer) {
        return buffer == null ? 0L : memUtil.getAddress(buffer);
    }

    public static long getAddress0(PointerBuffer buffer) {
        return memUtil.getAddress(buffer.getBuffer());
    }

    public static long getAddress0Safe(PointerBuffer buffer) {
        return buffer == null ? 0L : memUtil.getAddress(buffer.getBuffer());
    }

    public static long getAddress(ByteBuffer buffer) {
        return MemoryUtil.getAddress(buffer, buffer.position());
    }

    public static long getAddress(ByteBuffer buffer, int position) {
        return MemoryUtil.getAddress0(buffer) + (long)position;
    }

    public static long getAddress(ShortBuffer buffer) {
        return MemoryUtil.getAddress(buffer, buffer.position());
    }

    public static long getAddress(ShortBuffer buffer, int position) {
        return MemoryUtil.getAddress0(buffer) + (long)(position << 1);
    }

    public static long getAddress(CharBuffer buffer) {
        return MemoryUtil.getAddress(buffer, buffer.position());
    }

    public static long getAddress(CharBuffer buffer, int position) {
        return MemoryUtil.getAddress0(buffer) + (long)(position << 1);
    }

    public static long getAddress(IntBuffer buffer) {
        return MemoryUtil.getAddress(buffer, buffer.position());
    }

    public static long getAddress(IntBuffer buffer, int position) {
        return MemoryUtil.getAddress0(buffer) + (long)(position << 2);
    }

    public static long getAddress(FloatBuffer buffer) {
        return MemoryUtil.getAddress(buffer, buffer.position());
    }

    public static long getAddress(FloatBuffer buffer, int position) {
        return MemoryUtil.getAddress0(buffer) + (long)(position << 2);
    }

    public static long getAddress(LongBuffer buffer) {
        return MemoryUtil.getAddress(buffer, buffer.position());
    }

    public static long getAddress(LongBuffer buffer, int position) {
        return MemoryUtil.getAddress0(buffer) + (long)(position << 3);
    }

    public static long getAddress(DoubleBuffer buffer) {
        return MemoryUtil.getAddress(buffer, buffer.position());
    }

    public static long getAddress(DoubleBuffer buffer, int position) {
        return MemoryUtil.getAddress0(buffer) + (long)(position << 3);
    }

    public static long getAddress(PointerBuffer buffer) {
        return MemoryUtil.getAddress(buffer, buffer.position());
    }

    public static long getAddress(PointerBuffer buffer, int position) {
        return MemoryUtil.getAddress0(buffer) + (long)(position * PointerBuffer.getPointerSize());
    }

    public static long getAddressSafe(ByteBuffer buffer) {
        return buffer == null ? 0L : MemoryUtil.getAddress(buffer);
    }

    public static long getAddressSafe(ByteBuffer buffer, int position) {
        return buffer == null ? 0L : MemoryUtil.getAddress(buffer, position);
    }

    public static long getAddressSafe(ShortBuffer buffer) {
        return buffer == null ? 0L : MemoryUtil.getAddress(buffer);
    }

    public static long getAddressSafe(ShortBuffer buffer, int position) {
        return buffer == null ? 0L : MemoryUtil.getAddress(buffer, position);
    }

    public static long getAddressSafe(CharBuffer buffer) {
        return buffer == null ? 0L : MemoryUtil.getAddress(buffer);
    }

    public static long getAddressSafe(CharBuffer buffer, int position) {
        return buffer == null ? 0L : MemoryUtil.getAddress(buffer, position);
    }

    public static long getAddressSafe(IntBuffer buffer) {
        return buffer == null ? 0L : MemoryUtil.getAddress(buffer);
    }

    public static long getAddressSafe(IntBuffer buffer, int position) {
        return buffer == null ? 0L : MemoryUtil.getAddress(buffer, position);
    }

    public static long getAddressSafe(FloatBuffer buffer) {
        return buffer == null ? 0L : MemoryUtil.getAddress(buffer);
    }

    public static long getAddressSafe(FloatBuffer buffer, int position) {
        return buffer == null ? 0L : MemoryUtil.getAddress(buffer, position);
    }

    public static long getAddressSafe(LongBuffer buffer) {
        return buffer == null ? 0L : MemoryUtil.getAddress(buffer);
    }

    public static long getAddressSafe(LongBuffer buffer, int position) {
        return buffer == null ? 0L : MemoryUtil.getAddress(buffer, position);
    }

    public static long getAddressSafe(DoubleBuffer buffer) {
        return buffer == null ? 0L : MemoryUtil.getAddress(buffer);
    }

    public static long getAddressSafe(DoubleBuffer buffer, int position) {
        return buffer == null ? 0L : MemoryUtil.getAddress(buffer, position);
    }

    public static long getAddressSafe(PointerBuffer buffer) {
        return buffer == null ? 0L : MemoryUtil.getAddress(buffer);
    }

    public static long getAddressSafe(PointerBuffer buffer, int position) {
        return buffer == null ? 0L : MemoryUtil.getAddress(buffer, position);
    }

    public static ByteBuffer encodeASCII(CharSequence text) {
        return MemoryUtil.encode(text, ascii);
    }

    public static ByteBuffer encodeUTF8(CharSequence text) {
        return MemoryUtil.encode(text, utf8);
    }

    public static ByteBuffer encodeUTF16(CharSequence text) {
        return MemoryUtil.encode(text, utf16);
    }

    private static ByteBuffer encode(CharSequence text, Charset charset) {
        if (text == null) {
            return null;
        }
        return MemoryUtil.encode(CharBuffer.wrap(new MemoryUtil$CharSequenceNT(text)), charset);
    }

    private static ByteBuffer encode(CharBuffer in, Charset charset) {
        CharsetEncoder charsetEncoder = charset.newEncoder();
        int n = (int)((float)in.remaining() * charsetEncoder.averageBytesPerChar());
        ByteBuffer byteBuffer = BufferUtils.createByteBuffer(n);
        if (n == 0 && in.remaining() == 0) {
            return byteBuffer;
        }
        charsetEncoder.reset();
        while (true) {
            CoderResult coderResult;
            CoderResult coderResult2 = coderResult = in.hasRemaining() ? charsetEncoder.encode(in, byteBuffer, true) : CoderResult.UNDERFLOW;
            if (coderResult.isUnderflow()) {
                coderResult = charsetEncoder.flush(byteBuffer);
            }
            if (coderResult.isUnderflow()) break;
            if (coderResult.isOverflow()) {
                n = 2 * n + 1;
                ByteBuffer byteBuffer2 = BufferUtils.createByteBuffer(n);
                byteBuffer.flip();
                byteBuffer2.put(byteBuffer);
                byteBuffer = byteBuffer2;
                continue;
            }
            try {
                coderResult.throwException();
            }
            catch (CharacterCodingException characterCodingException) {
                throw new RuntimeException(characterCodingException);
            }
        }
        byteBuffer.flip();
        return byteBuffer;
    }

    public static String decodeASCII(ByteBuffer buffer) {
        return MemoryUtil.decode(buffer, ascii);
    }

    public static String decodeUTF8(ByteBuffer buffer) {
        return MemoryUtil.decode(buffer, utf8);
    }

    public static String decodeUTF16(ByteBuffer buffer) {
        return MemoryUtil.decode(buffer, utf16);
    }

    private static String decode(ByteBuffer buffer, Charset charset) {
        if (buffer == null) {
            return null;
        }
        return MemoryUtil.decodeImpl(buffer, charset);
    }

    private static String decodeImpl(ByteBuffer in, Charset charset) {
        CharsetDecoder charsetDecoder = charset.newDecoder();
        int n = (int)((float)in.remaining() * charsetDecoder.averageCharsPerByte());
        CharBuffer charBuffer = BufferUtils.createCharBuffer(n);
        if (n == 0 && in.remaining() == 0) {
            return "";
        }
        charsetDecoder.reset();
        while (true) {
            CoderResult coderResult;
            CoderResult coderResult2 = coderResult = in.hasRemaining() ? charsetDecoder.decode(in, charBuffer, true) : CoderResult.UNDERFLOW;
            if (coderResult.isUnderflow()) {
                coderResult = charsetDecoder.flush(charBuffer);
            }
            if (coderResult.isUnderflow()) break;
            if (coderResult.isOverflow()) {
                n = 2 * n + 1;
                CharBuffer charBuffer2 = BufferUtils.createCharBuffer(n);
                charBuffer.flip();
                charBuffer2.put(charBuffer);
                charBuffer = charBuffer2;
                continue;
            }
            try {
                coderResult.throwException();
            }
            catch (CharacterCodingException characterCodingException) {
                throw new RuntimeException(characterCodingException);
            }
        }
        charBuffer.flip();
        return charBuffer.toString();
    }

    private static MemoryUtil$Accessor loadAccessor(String className) {
        return (MemoryUtil$Accessor)Class.forName(className).newInstance();
    }

    static Field getAddressField() {
        return MemoryUtil.getDeclaredFieldRecursive(ByteBuffer.class, "address");
    }

    private static Field getDeclaredFieldRecursive(Class<?> root, String fieldName) {
        Class<?> clazz = root;
        while (true) {
            try {
                return clazz.getDeclaredField(fieldName);
            }
            catch (NoSuchFieldException noSuchFieldException) {
                if ((clazz = clazz.getSuperclass()) != null) continue;
                throw new NoSuchFieldException(fieldName + " does not exist in " + root.getSimpleName() + " or any of its superclasses.");
            }
            break;
        }
    }

    static {
        MemoryUtil$Accessor memoryUtil$Accessor;
        ascii = Charset.forName("ISO-8859-1");
        utf8 = Charset.forName("UTF-8");
        utf16 = Charset.forName("UTF-16LE");
        try {
            memoryUtil$Accessor = MemoryUtil.loadAccessor("org.lwjgl.MemoryUtilSun$AccessorUnsafe");
        }
        catch (Exception exception) {
            try {
                memoryUtil$Accessor = MemoryUtil.loadAccessor("org.lwjgl.MemoryUtilSun$AccessorReflectFast");
            }
            catch (Exception exception2) {
                try {
                    memoryUtil$Accessor = new MemoryUtil$AccessorReflect();
                }
                catch (Exception exception3) {
                    LWJGLUtil.log("Unsupported JVM detected, this will likely result in low performance. Please inform LWJGL developers.");
                    memoryUtil$Accessor = new MemoryUtil$AccessorJNI(null);
                }
            }
        }
        LWJGLUtil.log("MemoryUtil Accessor: " + memoryUtil$Accessor.getClass().getSimpleName());
        memUtil = memoryUtil$Accessor;
    }
}

