/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl;

import java.lang.reflect.Method;
import java.nio.Buffer;
import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.LWJGLUtil;
import org.lwjgl.MemoryUtil;
import org.lwjgl.PointerBuffer$PointerBufferR;
import org.lwjgl.PointerWrapper;

public class PointerBuffer
implements Comparable {
    private static final boolean is64Bit;
    protected final ByteBuffer pointers;
    protected final Buffer view;
    protected final IntBuffer view32;
    protected final LongBuffer view64;

    public PointerBuffer(int capacity) {
        this(BufferUtils.createByteBuffer(capacity * PointerBuffer.getPointerSize()));
    }

    public PointerBuffer(ByteBuffer source) {
        if (LWJGLUtil.CHECKS) {
            PointerBuffer.checkSource(source);
        }
        this.pointers = source.slice().order(source.order());
        if (is64Bit) {
            this.view32 = null;
            this.view64 = this.pointers.asLongBuffer();
            this.view = this.view64;
        } else {
            this.view32 = this.pointers.asIntBuffer();
            this.view = this.view32;
            this.view64 = null;
        }
    }

    private static void checkSource(ByteBuffer source) {
        int n;
        if (!source.isDirect()) {
            throw new IllegalArgumentException("The source buffer is not direct.");
        }
        int n2 = n = is64Bit ? 8 : 4;
        if ((MemoryUtil.getAddress0(source) + (long)source.position()) % (long)n != 0L || source.remaining() % n != 0) {
            throw new IllegalArgumentException("The source buffer is not aligned to " + n + " bytes.");
        }
    }

    public ByteBuffer getBuffer() {
        return this.pointers;
    }

    public static boolean is64Bit() {
        return is64Bit;
    }

    public static int getPointerSize() {
        return is64Bit ? 8 : 4;
    }

    public final int capacity() {
        return this.view.capacity();
    }

    public final int position() {
        return this.view.position();
    }

    public final int positionByte() {
        return this.position() * PointerBuffer.getPointerSize();
    }

    public final PointerBuffer position(int newPosition) {
        this.view.position(newPosition);
        return this;
    }

    public final int limit() {
        return this.view.limit();
    }

    public final PointerBuffer limit(int newLimit) {
        this.view.limit(newLimit);
        return this;
    }

    public final PointerBuffer mark() {
        this.view.mark();
        return this;
    }

    public final PointerBuffer reset() {
        this.view.reset();
        return this;
    }

    public final PointerBuffer clear() {
        this.view.clear();
        return this;
    }

    public final PointerBuffer flip() {
        this.view.flip();
        return this;
    }

    public final PointerBuffer rewind() {
        this.view.rewind();
        return this;
    }

    public final int remaining() {
        return this.view.remaining();
    }

    public final int remainingByte() {
        return this.remaining() * PointerBuffer.getPointerSize();
    }

    public final boolean hasRemaining() {
        return this.view.hasRemaining();
    }

    public static PointerBuffer allocateDirect(int capacity) {
        return new PointerBuffer(capacity);
    }

    protected PointerBuffer newInstance(ByteBuffer source) {
        return new PointerBuffer(source);
    }

    public PointerBuffer slice() {
        int n = PointerBuffer.getPointerSize();
        this.pointers.position(this.view.position() * n);
        this.pointers.limit(this.view.limit() * n);
        try {
            PointerBuffer pointerBuffer = this.newInstance(this.pointers);
            return pointerBuffer;
        }
        finally {
            this.pointers.clear();
        }
    }

    public PointerBuffer duplicate() {
        PointerBuffer pointerBuffer = this.newInstance(this.pointers);
        pointerBuffer.position(this.view.position());
        pointerBuffer.limit(this.view.limit());
        return pointerBuffer;
    }

    public PointerBuffer asReadOnlyBuffer() {
        PointerBuffer$PointerBufferR pointerBuffer$PointerBufferR = new PointerBuffer$PointerBufferR(this.pointers);
        pointerBuffer$PointerBufferR.position(this.view.position());
        pointerBuffer$PointerBufferR.limit(this.view.limit());
        return pointerBuffer$PointerBufferR;
    }

    public boolean isReadOnly() {
        return false;
    }

    public long get() {
        if (is64Bit) {
            return this.view64.get();
        }
        return (long)this.view32.get() & 0xFFFFFFFFL;
    }

    public PointerBuffer put(long l) {
        if (is64Bit) {
            this.view64.put(l);
        } else {
            this.view32.put((int)l);
        }
        return this;
    }

    public PointerBuffer put(PointerWrapper pointer) {
        return this.put(pointer.getPointer());
    }

    public static void put(ByteBuffer target, long l) {
        if (is64Bit) {
            target.putLong(l);
        } else {
            target.putInt((int)l);
        }
    }

    public long get(int index) {
        if (is64Bit) {
            return this.view64.get(index);
        }
        return (long)this.view32.get(index) & 0xFFFFFFFFL;
    }

    public PointerBuffer put(int index, long l) {
        if (is64Bit) {
            this.view64.put(index, l);
        } else {
            this.view32.put(index, (int)l);
        }
        return this;
    }

    public PointerBuffer put(int index, PointerWrapper pointer) {
        return this.put(index, pointer.getPointer());
    }

    public static void put(ByteBuffer target, int index, long l) {
        if (is64Bit) {
            target.putLong(index, l);
        } else {
            target.putInt(index, (int)l);
        }
    }

    public PointerBuffer get(long[] dst, int offset, int length) {
        if (is64Bit) {
            this.view64.get(dst, offset, length);
        } else {
            PointerBuffer.checkBounds(offset, length, dst.length);
            if (length > this.view32.remaining()) {
                throw new BufferUnderflowException();
            }
            int n = offset + length;
            for (int i = offset; i < n; ++i) {
                dst[i] = (long)this.view32.get() & 0xFFFFFFFFL;
            }
        }
        return this;
    }

    public PointerBuffer get(long[] dst) {
        return this.get(dst, 0, dst.length);
    }

    public PointerBuffer put(PointerBuffer src) {
        if (is64Bit) {
            this.view64.put(src.view64);
        } else {
            this.view32.put(src.view32);
        }
        return this;
    }

    public PointerBuffer put(long[] src, int offset, int length) {
        if (is64Bit) {
            this.view64.put(src, offset, length);
        } else {
            PointerBuffer.checkBounds(offset, length, src.length);
            if (length > this.view32.remaining()) {
                throw new BufferOverflowException();
            }
            int n = offset + length;
            for (int i = offset; i < n; ++i) {
                this.view32.put((int)src[i]);
            }
        }
        return this;
    }

    public final PointerBuffer put(long[] src) {
        return this.put(src, 0, src.length);
    }

    public PointerBuffer compact() {
        if (is64Bit) {
            this.view64.compact();
        } else {
            this.view32.compact();
        }
        return this;
    }

    public ByteOrder order() {
        if (is64Bit) {
            return this.view64.order();
        }
        return this.view32.order();
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(48);
        stringBuilder.append(this.getClass().getName());
        stringBuilder.append("[pos=");
        stringBuilder.append(this.position());
        stringBuilder.append(" lim=");
        stringBuilder.append(this.limit());
        stringBuilder.append(" cap=");
        stringBuilder.append(this.capacity());
        stringBuilder.append("]");
        return stringBuilder.toString();
    }

    public int hashCode() {
        int n = 1;
        int n2 = this.position();
        for (int i = this.limit() - 1; i >= n2; --i) {
            n = 31 * n + (int)this.get(i);
        }
        return n;
    }

    public boolean equals(Object ob) {
        if (!(ob instanceof PointerBuffer)) {
            return false;
        }
        PointerBuffer pointerBuffer = (PointerBuffer)ob;
        if (this.remaining() != pointerBuffer.remaining()) {
            return false;
        }
        int n = this.position();
        int n2 = this.limit() - 1;
        int n3 = pointerBuffer.limit() - 1;
        while (n2 >= n) {
            long l;
            long l2 = this.get(n2);
            if (l2 != (l = pointerBuffer.get(n3))) {
                return false;
            }
            --n2;
            --n3;
        }
        return true;
    }

    public int compareTo(Object o) {
        PointerBuffer pointerBuffer = (PointerBuffer)o;
        int n = this.position() + Math.min(this.remaining(), pointerBuffer.remaining());
        int n2 = this.position();
        int n3 = pointerBuffer.position();
        while (n2 < n) {
            long l;
            long l2 = this.get(n2);
            if (l2 != (l = pointerBuffer.get(n3))) {
                if (l2 < l) {
                    return -1;
                }
                return 1;
            }
            ++n2;
            ++n3;
        }
        return this.remaining() - pointerBuffer.remaining();
    }

    private static void checkBounds(int off, int len, int size) {
        if ((off | len | off + len | size - (off + len)) < 0) {
            throw new IndexOutOfBoundsException();
        }
    }

    static {
        boolean bl = false;
        try {
            Method method = Class.forName("org.lwjgl.Sys").getDeclaredMethod("is64Bit", null);
            bl = (Boolean)method.invoke(null, (Object[])null);
        }
        catch (Throwable throwable) {
        }
        finally {
            is64Bit = bl;
        }
    }
}

