/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.input;

import java.util.ArrayList;
import net.java.games.input.Component;
import net.java.games.input.Event;
import net.java.games.input.EventQueue;
import net.java.games.input.Rumbler;
import org.lwjgl.input.Controller;
import org.lwjgl.input.ControllerEvent;
import org.lwjgl.input.Controllers;

class JInputController
implements Controller {
    private net.java.games.input.Controller target;
    private int index;
    private ArrayList<Component> buttons = new ArrayList();
    private ArrayList<Component> axes = new ArrayList();
    private ArrayList<Component> pov = new ArrayList();
    private Rumbler[] rumblers;
    private boolean[] buttonState;
    private float[] povValues;
    private float[] axesValue;
    private float[] axesMax;
    private float[] deadZones;
    private int xaxis = -1;
    private int yaxis = -1;
    private int zaxis = -1;
    private int rxaxis = -1;
    private int ryaxis = -1;
    private int rzaxis = -1;

    JInputController(int index, net.java.games.input.Controller target) {
        Component[] componentArray;
        this.target = target;
        this.index = index;
        for (Component component : componentArray = target.getComponents()) {
            if (component.getIdentifier() instanceof Component.Identifier.Button) {
                this.buttons.add(component);
                continue;
            }
            if (component.getIdentifier().equals(Component.Identifier.Axis.POV)) {
                this.pov.add(component);
                continue;
            }
            this.axes.add(component);
        }
        this.buttonState = new boolean[this.buttons.size()];
        this.povValues = new float[this.pov.size()];
        this.axesValue = new float[this.axes.size()];
        int n = 0;
        int n2 = 0;
        for (Component component : componentArray) {
            if (component.getIdentifier() instanceof Component.Identifier.Button) {
                this.buttonState[n] = component.getPollData() != 0.0f;
                ++n;
                continue;
            }
            if (component.getIdentifier().equals(Component.Identifier.Axis.POV)) continue;
            this.axesValue[n2] = component.getPollData();
            if (component.getIdentifier().equals(Component.Identifier.Axis.X)) {
                this.xaxis = n2;
            }
            if (component.getIdentifier().equals(Component.Identifier.Axis.Y)) {
                this.yaxis = n2;
            }
            if (component.getIdentifier().equals(Component.Identifier.Axis.Z)) {
                this.zaxis = n2;
            }
            if (component.getIdentifier().equals(Component.Identifier.Axis.RX)) {
                this.rxaxis = n2;
            }
            if (component.getIdentifier().equals(Component.Identifier.Axis.RY)) {
                this.ryaxis = n2;
            }
            if (component.getIdentifier().equals(Component.Identifier.Axis.RZ)) {
                this.rzaxis = n2;
            }
            ++n2;
        }
        this.axesMax = new float[this.axes.size()];
        this.deadZones = new float[this.axes.size()];
        for (int i = 0; i < this.axesMax.length; ++i) {
            this.axesMax[i] = 1.0f;
            this.deadZones[i] = 0.05f;
        }
        this.rumblers = target.getRumblers();
    }

    @Override
    public String getName() {
        String string = this.target.getName();
        return string;
    }

    @Override
    public int getIndex() {
        return this.index;
    }

    @Override
    public int getButtonCount() {
        return this.buttons.size();
    }

    @Override
    public String getButtonName(int index) {
        return this.buttons.get(index).getName();
    }

    @Override
    public boolean isButtonPressed(int index) {
        return this.buttonState[index];
    }

    @Override
    public void poll() {
        this.target.poll();
        Event event = new Event();
        EventQueue eventQueue = this.target.getEventQueue();
        while (eventQueue.getNextEvent(event)) {
            float f;
            float f2;
            int n;
            Component component;
            if (this.buttons.contains(event.getComponent())) {
                component = event.getComponent();
                n = this.buttons.indexOf(component);
                this.buttonState[n] = event.getValue() != 0.0f;
                Controllers.addEvent(new ControllerEvent(this, event.getNanos(), 1, n, this.buttonState[n], false, false, 0.0f, 0.0f));
            }
            if (this.pov.contains(event.getComponent())) {
                component = event.getComponent();
                n = this.pov.indexOf(component);
                f2 = this.getPovX();
                f = this.getPovY();
                this.povValues[n] = event.getValue();
                if (f2 != this.getPovX()) {
                    Controllers.addEvent(new ControllerEvent(this, event.getNanos(), 3, 0, false, false));
                }
                if (f != this.getPovY()) {
                    Controllers.addEvent(new ControllerEvent(this, event.getNanos(), 4, 0, false, false));
                }
            }
            if (!this.axes.contains(event.getComponent())) continue;
            component = event.getComponent();
            n = this.axes.indexOf(component);
            f2 = component.getPollData();
            f = 0.0f;
            float f3 = 0.0f;
            if (Math.abs(f2) < this.deadZones[n]) {
                f2 = 0.0f;
            }
            if (Math.abs(f2) < component.getDeadZone()) {
                f2 = 0.0f;
            }
            if (Math.abs(f2) > this.axesMax[n]) {
                this.axesMax[n] = Math.abs(f2);
            }
            f2 /= this.axesMax[n];
            if (n == this.xaxis) {
                f = f2;
            }
            if (n == this.yaxis) {
                f3 = f2;
            }
            Controllers.addEvent(new ControllerEvent(this, event.getNanos(), 2, n, false, n == this.xaxis, n == this.yaxis, f, f3));
            this.axesValue[n] = f2;
        }
    }

    @Override
    public int getAxisCount() {
        return this.axes.size();
    }

    @Override
    public String getAxisName(int index) {
        return this.axes.get(index).getName();
    }

    @Override
    public float getAxisValue(int index) {
        return this.axesValue[index];
    }

    @Override
    public float getXAxisValue() {
        if (this.xaxis == -1) {
            return 0.0f;
        }
        return this.getAxisValue(this.xaxis);
    }

    @Override
    public float getYAxisValue() {
        if (this.yaxis == -1) {
            return 0.0f;
        }
        return this.getAxisValue(this.yaxis);
    }

    @Override
    public float getXAxisDeadZone() {
        if (this.xaxis == -1) {
            return 0.0f;
        }
        return this.getDeadZone(this.xaxis);
    }

    @Override
    public float getYAxisDeadZone() {
        if (this.yaxis == -1) {
            return 0.0f;
        }
        return this.getDeadZone(this.yaxis);
    }

    @Override
    public void setXAxisDeadZone(float zone) {
        this.setDeadZone(this.xaxis, zone);
    }

    @Override
    public void setYAxisDeadZone(float zone) {
        this.setDeadZone(this.yaxis, zone);
    }

    @Override
    public float getDeadZone(int index) {
        return this.deadZones[index];
    }

    @Override
    public void setDeadZone(int index, float zone) {
        this.deadZones[index] = zone;
    }

    @Override
    public float getZAxisValue() {
        if (this.zaxis == -1) {
            return 0.0f;
        }
        return this.getAxisValue(this.zaxis);
    }

    @Override
    public float getZAxisDeadZone() {
        if (this.zaxis == -1) {
            return 0.0f;
        }
        return this.getDeadZone(this.zaxis);
    }

    @Override
    public void setZAxisDeadZone(float zone) {
        this.setDeadZone(this.zaxis, zone);
    }

    @Override
    public float getRXAxisValue() {
        if (this.rxaxis == -1) {
            return 0.0f;
        }
        return this.getAxisValue(this.rxaxis);
    }

    @Override
    public float getRXAxisDeadZone() {
        if (this.rxaxis == -1) {
            return 0.0f;
        }
        return this.getDeadZone(this.rxaxis);
    }

    @Override
    public void setRXAxisDeadZone(float zone) {
        this.setDeadZone(this.rxaxis, zone);
    }

    @Override
    public float getRYAxisValue() {
        if (this.ryaxis == -1) {
            return 0.0f;
        }
        return this.getAxisValue(this.ryaxis);
    }

    @Override
    public float getRYAxisDeadZone() {
        if (this.ryaxis == -1) {
            return 0.0f;
        }
        return this.getDeadZone(this.ryaxis);
    }

    @Override
    public void setRYAxisDeadZone(float zone) {
        this.setDeadZone(this.ryaxis, zone);
    }

    @Override
    public float getRZAxisValue() {
        if (this.rzaxis == -1) {
            return 0.0f;
        }
        return this.getAxisValue(this.rzaxis);
    }

    @Override
    public float getRZAxisDeadZone() {
        if (this.rzaxis == -1) {
            return 0.0f;
        }
        return this.getDeadZone(this.rzaxis);
    }

    @Override
    public void setRZAxisDeadZone(float zone) {
        this.setDeadZone(this.rzaxis, zone);
    }

    @Override
    public float getPovX() {
        if (this.pov.size() == 0) {
            return 0.0f;
        }
        float f = this.povValues[0];
        if (f == 0.875f || f == 0.125f || f == 1.0f) {
            return -1.0f;
        }
        if (f == 0.625f || f == 0.375f || f == 0.5f) {
            return 1.0f;
        }
        return 0.0f;
    }

    @Override
    public float getPovY() {
        if (this.pov.size() == 0) {
            return 0.0f;
        }
        float f = this.povValues[0];
        if (f == 0.875f || f == 0.625f || f == 0.75f) {
            return 1.0f;
        }
        if (f == 0.125f || f == 0.375f || f == 0.25f) {
            return -1.0f;
        }
        return 0.0f;
    }

    @Override
    public int getRumblerCount() {
        return this.rumblers.length;
    }

    @Override
    public String getRumblerName(int index) {
        return this.rumblers[index].getAxisName();
    }

    @Override
    public void setRumblerStrength(int index, float strength) {
        this.rumblers[index].rumble(strength);
    }
}

