/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openal;

import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.util.HashMap;
import org.lwjgl.BufferUtils;
import org.lwjgl.LWJGLException;
import org.lwjgl.LWJGLUtil;
import org.lwjgl.MemoryUtil;
import org.lwjgl.openal.AL;
import org.lwjgl.openal.AL11;
import org.lwjgl.openal.ALC10;
import org.lwjgl.openal.ALCdevice;

public final class ALC11 {
    public static final int ALC_DEFAULT_ALL_DEVICES_SPECIFIER = 4114;
    public static final int ALC_ALL_DEVICES_SPECIFIER = 4115;
    public static final int ALC_CAPTURE_DEVICE_SPECIFIER = 784;
    public static final int ALC_CAPTURE_DEFAULT_DEVICE_SPECIFIER = 785;
    public static final int ALC_CAPTURE_SAMPLES = 786;
    public static final int ALC_MONO_SOURCES = 4112;
    public static final int ALC_STEREO_SOURCES = 4113;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ALCdevice alcCaptureOpenDevice(String devicename, int frequency, int format, int buffersize) {
        ByteBuffer byteBuffer = MemoryUtil.encodeASCII(devicename);
        long l = ALC11.nalcCaptureOpenDevice(MemoryUtil.getAddressSafe(byteBuffer), frequency, format, buffersize);
        if (l != 0L) {
            ALCdevice aLCdevice = new ALCdevice(l);
            HashMap<Long, ALCdevice> hashMap = ALC10.devices;
            synchronized (hashMap) {
                ALC10.devices.put(l, aLCdevice);
            }
            return aLCdevice;
        }
        return null;
    }

    private static native long nalcCaptureOpenDevice(long var0, int var2, int var3, int var4);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean alcCaptureCloseDevice(ALCdevice device) {
        boolean bl = ALC11.nalcCaptureCloseDevice(ALC10.getDevice(device));
        HashMap<Long, ALCdevice> hashMap = ALC10.devices;
        synchronized (hashMap) {
            device.setInvalid();
            ALC10.devices.remove(new Long(device.device));
        }
        return bl;
    }

    static native boolean nalcCaptureCloseDevice(long var0);

    public static void alcCaptureStart(ALCdevice device) {
        ALC11.nalcCaptureStart(ALC10.getDevice(device));
    }

    static native void nalcCaptureStart(long var0);

    public static void alcCaptureStop(ALCdevice device) {
        ALC11.nalcCaptureStop(ALC10.getDevice(device));
    }

    static native void nalcCaptureStop(long var0);

    public static void alcCaptureSamples(ALCdevice device, ByteBuffer buffer, int samples) {
        ALC11.nalcCaptureSamples(ALC10.getDevice(device), MemoryUtil.getAddress(buffer), samples);
    }

    static native void nalcCaptureSamples(long var0, long var2, int var4);

    static native void initNativeStubs();

    static boolean initialize() {
        try {
            IntBuffer intBuffer = BufferUtils.createIntBuffer(2);
            ALC10.alcGetInteger(AL.getDevice(), 4096, intBuffer);
            intBuffer.position(1);
            ALC10.alcGetInteger(AL.getDevice(), 4097, intBuffer);
            int n = intBuffer.get(0);
            int n2 = intBuffer.get(1);
            if (n >= 1 && (n > 1 || n2 >= 1)) {
                ALC11.initNativeStubs();
                AL11.initNativeStubs();
            }
        }
        catch (LWJGLException lWJGLException) {
            LWJGLUtil.log("failed to initialize ALC11: " + lWJGLException);
            return false;
        }
        return true;
    }
}

