/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opencl;

import org.lwjgl.opencl.FastLongMap$Entry;
import org.lwjgl.opencl.FastLongMap$EntryIterator;

final class FastLongMap<V>
implements Iterable<FastLongMap$Entry<V>> {
    private FastLongMap$Entry[] table;
    private int size;
    private int mask;
    private int capacity;
    private int threshold;

    FastLongMap() {
        this(16, 0.75f);
    }

    FastLongMap(int initialCapacity) {
        this(initialCapacity, 0.75f);
    }

    FastLongMap(int initialCapacity, float loadFactor) {
        if (initialCapacity > 0x40000000) {
            throw new IllegalArgumentException("initialCapacity is too large.");
        }
        if (initialCapacity < 0) {
            throw new IllegalArgumentException("initialCapacity must be greater than zero.");
        }
        if (loadFactor <= 0.0f) {
            throw new IllegalArgumentException("initialCapacity must be greater than zero.");
        }
        this.capacity = 1;
        while (this.capacity < initialCapacity) {
            this.capacity <<= 1;
        }
        this.threshold = (int)((float)this.capacity * loadFactor);
        this.table = new FastLongMap$Entry[this.capacity];
        this.mask = this.capacity - 1;
    }

    private int index(long key) {
        return FastLongMap.index(key, this.mask);
    }

    private static int index(long key, int mask) {
        int n = (int)(key ^ key >>> 32);
        return n & mask;
    }

    public V put(long key, V value) {
        FastLongMap$Entry[] fastLongMap$EntryArray = this.table;
        int n = this.index(key);
        FastLongMap$Entry fastLongMap$Entry = fastLongMap$EntryArray[n];
        while (fastLongMap$Entry != null) {
            if (fastLongMap$Entry.key == key) {
                Object t = fastLongMap$Entry.value;
                fastLongMap$Entry.value = value;
                return (V)t;
            }
            fastLongMap$Entry = fastLongMap$Entry.next;
        }
        fastLongMap$EntryArray[n] = new FastLongMap$Entry<V>(key, value, fastLongMap$EntryArray[n]);
        if (this.size++ >= this.threshold) {
            this.rehash(fastLongMap$EntryArray);
        }
        return null;
    }

    private void rehash(FastLongMap$Entry<V>[] table) {
        int n = 2 * this.capacity;
        int n2 = n - 1;
        FastLongMap$Entry[] fastLongMap$EntryArray = new FastLongMap$Entry[n];
        for (int i = 0; i < table.length; ++i) {
            FastLongMap$Entry fastLongMap$Entry;
            FastLongMap$Entry<Object> fastLongMap$Entry2 = table[i];
            if (fastLongMap$Entry2 == null) continue;
            do {
                fastLongMap$Entry = fastLongMap$Entry2.next;
                int n3 = FastLongMap.index(fastLongMap$Entry2.key, n2);
                fastLongMap$Entry2.next = fastLongMap$EntryArray[n3];
                fastLongMap$EntryArray[n3] = fastLongMap$Entry2;
            } while ((fastLongMap$Entry2 = fastLongMap$Entry) != null);
        }
        this.table = fastLongMap$EntryArray;
        this.capacity = n;
        this.mask = n2;
        this.threshold *= 2;
    }

    public V get(long key) {
        int n = this.index(key);
        FastLongMap$Entry fastLongMap$Entry = this.table[n];
        while (fastLongMap$Entry != null) {
            if (fastLongMap$Entry.key == key) {
                return (V)fastLongMap$Entry.value;
            }
            fastLongMap$Entry = fastLongMap$Entry.next;
        }
        return null;
    }

    public boolean containsValue(Object value) {
        FastLongMap$Entry[] fastLongMap$EntryArray = this.table;
        for (int i = fastLongMap$EntryArray.length - 1; i >= 0; --i) {
            FastLongMap$Entry fastLongMap$Entry = fastLongMap$EntryArray[i];
            while (fastLongMap$Entry != null) {
                if (fastLongMap$Entry.value.equals(value)) {
                    return true;
                }
                fastLongMap$Entry = fastLongMap$Entry.next;
            }
        }
        return false;
    }

    public boolean containsKey(long key) {
        int n = this.index(key);
        FastLongMap$Entry fastLongMap$Entry = this.table[n];
        while (fastLongMap$Entry != null) {
            if (fastLongMap$Entry.key == key) {
                return true;
            }
            fastLongMap$Entry = fastLongMap$Entry.next;
        }
        return false;
    }

    public V remove(long key) {
        FastLongMap$Entry fastLongMap$Entry;
        int n = this.index(key);
        FastLongMap$Entry fastLongMap$Entry2 = fastLongMap$Entry = this.table[n];
        while (fastLongMap$Entry2 != null) {
            FastLongMap$Entry fastLongMap$Entry3 = fastLongMap$Entry2.next;
            if (fastLongMap$Entry2.key == key) {
                --this.size;
                if (fastLongMap$Entry == fastLongMap$Entry2) {
                    this.table[n] = fastLongMap$Entry3;
                } else {
                    fastLongMap$Entry.next = fastLongMap$Entry3;
                }
                return (V)fastLongMap$Entry2.value;
            }
            fastLongMap$Entry = fastLongMap$Entry2;
            fastLongMap$Entry2 = fastLongMap$Entry3;
        }
        return null;
    }

    public int size() {
        return this.size;
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    public void clear() {
        FastLongMap$Entry[] fastLongMap$EntryArray = this.table;
        for (int i = fastLongMap$EntryArray.length - 1; i >= 0; --i) {
            fastLongMap$EntryArray[i] = null;
        }
        this.size = 0;
    }

    public FastLongMap$EntryIterator iterator() {
        return new FastLongMap$EntryIterator(this);
    }

    static /* synthetic */ FastLongMap$Entry[] access$000(FastLongMap x0) {
        return x0.table;
    }
}

