/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opengl;

import java.nio.ByteBuffer;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.LWJGLUtil;
import org.lwjgl.MemoryUtil;
import org.lwjgl.opengl.ContextCapabilities;

final class APIUtil {
    private static final int INITIAL_BUFFER_SIZE = 256;
    private static final int INITIAL_LENGTHS_SIZE = 4;
    private static final int BUFFERS_SIZE = 32;
    private char[] array = new char[256];
    private ByteBuffer buffer = BufferUtils.createByteBuffer(256);
    private IntBuffer lengths = BufferUtils.createIntBuffer(4);
    private final IntBuffer ints = BufferUtils.createIntBuffer(32);
    private final LongBuffer longs = BufferUtils.createLongBuffer(32);
    private final FloatBuffer floats = BufferUtils.createFloatBuffer(32);
    private final DoubleBuffer doubles = BufferUtils.createDoubleBuffer(32);

    APIUtil() {
    }

    private static char[] getArray(ContextCapabilities caps, int size) {
        char[] cArray = caps.util.array;
        if (cArray.length < size) {
            for (int i = cArray.length << 1; i < size; i <<= 1) {
            }
            caps.util.array = cArray = new char[size];
        }
        return cArray;
    }

    static ByteBuffer getBufferByte(ContextCapabilities caps, int size) {
        ByteBuffer byteBuffer = caps.util.buffer;
        if (byteBuffer.capacity() < size) {
            for (int i = byteBuffer.capacity() << 1; i < size; i <<= 1) {
            }
            caps.util.buffer = byteBuffer = BufferUtils.createByteBuffer(size);
        } else {
            byteBuffer.clear();
        }
        return byteBuffer;
    }

    private static ByteBuffer getBufferByteOffset(ContextCapabilities caps, int size) {
        ByteBuffer byteBuffer = caps.util.buffer;
        if (byteBuffer.capacity() < size) {
            for (int i = byteBuffer.capacity() << 1; i < size; i <<= 1) {
            }
            ByteBuffer byteBuffer2 = BufferUtils.createByteBuffer(size);
            byteBuffer2.put(byteBuffer);
            caps.util.buffer = byteBuffer = byteBuffer2;
        } else {
            byteBuffer.position(byteBuffer.limit());
            byteBuffer.limit(byteBuffer.capacity());
        }
        return byteBuffer;
    }

    static IntBuffer getBufferInt(ContextCapabilities caps) {
        return caps.util.ints;
    }

    static LongBuffer getBufferLong(ContextCapabilities caps) {
        return caps.util.longs;
    }

    static FloatBuffer getBufferFloat(ContextCapabilities caps) {
        return caps.util.floats;
    }

    static DoubleBuffer getBufferDouble(ContextCapabilities caps) {
        return caps.util.doubles;
    }

    static IntBuffer getLengths(ContextCapabilities caps) {
        return APIUtil.getLengths(caps, 1);
    }

    static IntBuffer getLengths(ContextCapabilities caps, int size) {
        IntBuffer intBuffer = caps.util.lengths;
        if (intBuffer.capacity() < size) {
            for (int i = intBuffer.capacity(); i < size; i <<= 1) {
            }
            caps.util.lengths = intBuffer = BufferUtils.createIntBuffer(size);
        } else {
            intBuffer.clear();
        }
        return intBuffer;
    }

    private static ByteBuffer encode(ByteBuffer buffer, CharSequence string) {
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (LWJGLUtil.DEBUG && '\u0080' <= c) {
                buffer.put((byte)26);
                continue;
            }
            buffer.put((byte)c);
        }
        return buffer;
    }

    static String getString(ContextCapabilities caps, ByteBuffer buffer) {
        int n = buffer.remaining();
        char[] cArray = APIUtil.getArray(caps, n);
        for (int i = buffer.position(); i < buffer.limit(); ++i) {
            cArray[i - buffer.position()] = (char)buffer.get(i);
        }
        return new String(cArray, 0, n);
    }

    static long getBuffer(ContextCapabilities caps, CharSequence string) {
        ByteBuffer byteBuffer = APIUtil.encode(APIUtil.getBufferByte(caps, string.length()), string);
        byteBuffer.flip();
        return MemoryUtil.getAddress0(byteBuffer);
    }

    static long getBuffer(ContextCapabilities caps, CharSequence string, int offset) {
        ByteBuffer byteBuffer = APIUtil.encode(APIUtil.getBufferByteOffset(caps, offset + string.length()), string);
        byteBuffer.flip();
        return MemoryUtil.getAddress(byteBuffer);
    }

    static long getBufferNT(ContextCapabilities caps, CharSequence string) {
        ByteBuffer byteBuffer = APIUtil.encode(APIUtil.getBufferByte(caps, string.length() + 1), string);
        byteBuffer.put((byte)0);
        byteBuffer.flip();
        return MemoryUtil.getAddress0(byteBuffer);
    }

    static int getTotalLength(CharSequence[] strings) {
        int n = 0;
        for (CharSequence charSequence : strings) {
            n += charSequence.length();
        }
        return n;
    }

    static long getBuffer(ContextCapabilities caps, CharSequence[] strings) {
        ByteBuffer byteBuffer = APIUtil.getBufferByte(caps, APIUtil.getTotalLength(strings));
        for (CharSequence charSequence : strings) {
            APIUtil.encode(byteBuffer, charSequence);
        }
        byteBuffer.flip();
        return MemoryUtil.getAddress0(byteBuffer);
    }

    static long getBufferNT(ContextCapabilities caps, CharSequence[] strings) {
        ByteBuffer byteBuffer = APIUtil.getBufferByte(caps, APIUtil.getTotalLength(strings) + strings.length);
        for (CharSequence charSequence : strings) {
            APIUtil.encode(byteBuffer, charSequence);
            byteBuffer.put((byte)0);
        }
        byteBuffer.flip();
        return MemoryUtil.getAddress0(byteBuffer);
    }

    static long getLengths(ContextCapabilities caps, CharSequence[] strings) {
        IntBuffer intBuffer = APIUtil.getLengths(caps, strings.length);
        for (CharSequence charSequence : strings) {
            intBuffer.put(charSequence.length());
        }
        intBuffer.flip();
        return MemoryUtil.getAddress0(intBuffer);
    }

    static long getInt(ContextCapabilities caps, int value) {
        return MemoryUtil.getAddress0(APIUtil.getBufferInt(caps).put(0, value));
    }

    static long getBufferByte0(ContextCapabilities caps) {
        return MemoryUtil.getAddress0(APIUtil.getBufferByte(caps, 0));
    }
}

