/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opengl;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.ShortBuffer;
import org.lwjgl.BufferChecks;
import org.lwjgl.LWJGLUtil;
import org.lwjgl.MemoryUtil;
import org.lwjgl.opengl.APIUtil;
import org.lwjgl.opengl.ContextCapabilities;
import org.lwjgl.opengl.GLChecks;
import org.lwjgl.opengl.GLContext;
import org.lwjgl.opengl.StateTracker;

public class ARBBufferObject {
    public static final int GL_STREAM_DRAW_ARB = 35040;
    public static final int GL_STREAM_READ_ARB = 35041;
    public static final int GL_STREAM_COPY_ARB = 35042;
    public static final int GL_STATIC_DRAW_ARB = 35044;
    public static final int GL_STATIC_READ_ARB = 35045;
    public static final int GL_STATIC_COPY_ARB = 35046;
    public static final int GL_DYNAMIC_DRAW_ARB = 35048;
    public static final int GL_DYNAMIC_READ_ARB = 35049;
    public static final int GL_DYNAMIC_COPY_ARB = 35050;
    public static final int GL_READ_ONLY_ARB = 35000;
    public static final int GL_WRITE_ONLY_ARB = 35001;
    public static final int GL_READ_WRITE_ARB = 35002;
    public static final int GL_BUFFER_SIZE_ARB = 34660;
    public static final int GL_BUFFER_USAGE_ARB = 34661;
    public static final int GL_BUFFER_ACCESS_ARB = 35003;
    public static final int GL_BUFFER_MAPPED_ARB = 35004;
    public static final int GL_BUFFER_MAP_POINTER_ARB = 35005;

    public static void glBindBufferARB(int target, int buffer) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glBindBufferARB;
        BufferChecks.checkFunctionAddress(l);
        StateTracker.bindBuffer(contextCapabilities, target, buffer);
        ARBBufferObject.nglBindBufferARB(target, buffer, l);
    }

    static native void nglBindBufferARB(int var0, int var1, long var2);

    public static void glDeleteBuffersARB(IntBuffer buffers) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glDeleteBuffersARB;
        BufferChecks.checkFunctionAddress(l);
        BufferChecks.checkDirect(buffers);
        ARBBufferObject.nglDeleteBuffersARB(buffers.remaining(), MemoryUtil.getAddress(buffers), l);
    }

    static native void nglDeleteBuffersARB(int var0, long var1, long var3);

    public static void glDeleteBuffersARB(int buffer) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glDeleteBuffersARB;
        BufferChecks.checkFunctionAddress(l);
        ARBBufferObject.nglDeleteBuffersARB(1, APIUtil.getInt(contextCapabilities, buffer), l);
    }

    public static void glGenBuffersARB(IntBuffer buffers) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glGenBuffersARB;
        BufferChecks.checkFunctionAddress(l);
        BufferChecks.checkDirect(buffers);
        ARBBufferObject.nglGenBuffersARB(buffers.remaining(), MemoryUtil.getAddress(buffers), l);
    }

    static native void nglGenBuffersARB(int var0, long var1, long var3);

    public static int glGenBuffersARB() {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glGenBuffersARB;
        BufferChecks.checkFunctionAddress(l);
        IntBuffer intBuffer = APIUtil.getBufferInt(contextCapabilities);
        ARBBufferObject.nglGenBuffersARB(1, MemoryUtil.getAddress(intBuffer), l);
        return intBuffer.get(0);
    }

    public static boolean glIsBufferARB(int buffer) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glIsBufferARB;
        BufferChecks.checkFunctionAddress(l);
        boolean bl = ARBBufferObject.nglIsBufferARB(buffer, l);
        return bl;
    }

    static native boolean nglIsBufferARB(int var0, long var1);

    public static void glBufferDataARB(int target, long data_size, int usage) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glBufferDataARB;
        BufferChecks.checkFunctionAddress(l);
        ARBBufferObject.nglBufferDataARB(target, data_size, 0L, usage, l);
    }

    public static void glBufferDataARB(int target, ByteBuffer data, int usage) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glBufferDataARB;
        BufferChecks.checkFunctionAddress(l);
        BufferChecks.checkDirect(data);
        ARBBufferObject.nglBufferDataARB(target, data.remaining(), MemoryUtil.getAddress(data), usage, l);
    }

    public static void glBufferDataARB(int target, DoubleBuffer data, int usage) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glBufferDataARB;
        BufferChecks.checkFunctionAddress(l);
        BufferChecks.checkDirect(data);
        ARBBufferObject.nglBufferDataARB(target, data.remaining() << 3, MemoryUtil.getAddress(data), usage, l);
    }

    public static void glBufferDataARB(int target, FloatBuffer data, int usage) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glBufferDataARB;
        BufferChecks.checkFunctionAddress(l);
        BufferChecks.checkDirect(data);
        ARBBufferObject.nglBufferDataARB(target, data.remaining() << 2, MemoryUtil.getAddress(data), usage, l);
    }

    public static void glBufferDataARB(int target, IntBuffer data, int usage) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glBufferDataARB;
        BufferChecks.checkFunctionAddress(l);
        BufferChecks.checkDirect(data);
        ARBBufferObject.nglBufferDataARB(target, data.remaining() << 2, MemoryUtil.getAddress(data), usage, l);
    }

    public static void glBufferDataARB(int target, ShortBuffer data, int usage) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glBufferDataARB;
        BufferChecks.checkFunctionAddress(l);
        BufferChecks.checkDirect(data);
        ARBBufferObject.nglBufferDataARB(target, data.remaining() << 1, MemoryUtil.getAddress(data), usage, l);
    }

    static native void nglBufferDataARB(int var0, long var1, long var3, int var5, long var6);

    public static void glBufferSubDataARB(int target, long offset, ByteBuffer data) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glBufferSubDataARB;
        BufferChecks.checkFunctionAddress(l);
        BufferChecks.checkDirect(data);
        ARBBufferObject.nglBufferSubDataARB(target, offset, data.remaining(), MemoryUtil.getAddress(data), l);
    }

    public static void glBufferSubDataARB(int target, long offset, DoubleBuffer data) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glBufferSubDataARB;
        BufferChecks.checkFunctionAddress(l);
        BufferChecks.checkDirect(data);
        ARBBufferObject.nglBufferSubDataARB(target, offset, data.remaining() << 3, MemoryUtil.getAddress(data), l);
    }

    public static void glBufferSubDataARB(int target, long offset, FloatBuffer data) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glBufferSubDataARB;
        BufferChecks.checkFunctionAddress(l);
        BufferChecks.checkDirect(data);
        ARBBufferObject.nglBufferSubDataARB(target, offset, data.remaining() << 2, MemoryUtil.getAddress(data), l);
    }

    public static void glBufferSubDataARB(int target, long offset, IntBuffer data) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glBufferSubDataARB;
        BufferChecks.checkFunctionAddress(l);
        BufferChecks.checkDirect(data);
        ARBBufferObject.nglBufferSubDataARB(target, offset, data.remaining() << 2, MemoryUtil.getAddress(data), l);
    }

    public static void glBufferSubDataARB(int target, long offset, ShortBuffer data) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glBufferSubDataARB;
        BufferChecks.checkFunctionAddress(l);
        BufferChecks.checkDirect(data);
        ARBBufferObject.nglBufferSubDataARB(target, offset, data.remaining() << 1, MemoryUtil.getAddress(data), l);
    }

    static native void nglBufferSubDataARB(int var0, long var1, long var3, long var5, long var7);

    public static void glGetBufferSubDataARB(int target, long offset, ByteBuffer data) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glGetBufferSubDataARB;
        BufferChecks.checkFunctionAddress(l);
        BufferChecks.checkDirect(data);
        ARBBufferObject.nglGetBufferSubDataARB(target, offset, data.remaining(), MemoryUtil.getAddress(data), l);
    }

    public static void glGetBufferSubDataARB(int target, long offset, DoubleBuffer data) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glGetBufferSubDataARB;
        BufferChecks.checkFunctionAddress(l);
        BufferChecks.checkDirect(data);
        ARBBufferObject.nglGetBufferSubDataARB(target, offset, data.remaining() << 3, MemoryUtil.getAddress(data), l);
    }

    public static void glGetBufferSubDataARB(int target, long offset, FloatBuffer data) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glGetBufferSubDataARB;
        BufferChecks.checkFunctionAddress(l);
        BufferChecks.checkDirect(data);
        ARBBufferObject.nglGetBufferSubDataARB(target, offset, data.remaining() << 2, MemoryUtil.getAddress(data), l);
    }

    public static void glGetBufferSubDataARB(int target, long offset, IntBuffer data) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glGetBufferSubDataARB;
        BufferChecks.checkFunctionAddress(l);
        BufferChecks.checkDirect(data);
        ARBBufferObject.nglGetBufferSubDataARB(target, offset, data.remaining() << 2, MemoryUtil.getAddress(data), l);
    }

    public static void glGetBufferSubDataARB(int target, long offset, ShortBuffer data) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glGetBufferSubDataARB;
        BufferChecks.checkFunctionAddress(l);
        BufferChecks.checkDirect(data);
        ARBBufferObject.nglGetBufferSubDataARB(target, offset, data.remaining() << 1, MemoryUtil.getAddress(data), l);
    }

    static native void nglGetBufferSubDataARB(int var0, long var1, long var3, long var5, long var7);

    public static ByteBuffer glMapBufferARB(int target, int access, ByteBuffer old_buffer) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glMapBufferARB;
        BufferChecks.checkFunctionAddress(l);
        if (old_buffer != null) {
            BufferChecks.checkDirect(old_buffer);
        }
        ByteBuffer byteBuffer = ARBBufferObject.nglMapBufferARB(target, access, GLChecks.getBufferObjectSizeARB(contextCapabilities, target), old_buffer, l);
        return LWJGLUtil.CHECKS && byteBuffer == null ? null : byteBuffer.order(ByteOrder.nativeOrder());
    }

    public static ByteBuffer glMapBufferARB(int target, int access, long length, ByteBuffer old_buffer) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glMapBufferARB;
        BufferChecks.checkFunctionAddress(l);
        if (old_buffer != null) {
            BufferChecks.checkDirect(old_buffer);
        }
        ByteBuffer byteBuffer = ARBBufferObject.nglMapBufferARB(target, access, length, old_buffer, l);
        return LWJGLUtil.CHECKS && byteBuffer == null ? null : byteBuffer.order(ByteOrder.nativeOrder());
    }

    static native ByteBuffer nglMapBufferARB(int var0, int var1, long var2, ByteBuffer var4, long var5);

    public static boolean glUnmapBufferARB(int target) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glUnmapBufferARB;
        BufferChecks.checkFunctionAddress(l);
        boolean bl = ARBBufferObject.nglUnmapBufferARB(target, l);
        return bl;
    }

    static native boolean nglUnmapBufferARB(int var0, long var1);

    public static void glGetBufferParameterARB(int target, int pname, IntBuffer params) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glGetBufferParameterivARB;
        BufferChecks.checkFunctionAddress(l);
        BufferChecks.checkBuffer(params, 4);
        ARBBufferObject.nglGetBufferParameterivARB(target, pname, MemoryUtil.getAddress(params), l);
    }

    static native void nglGetBufferParameterivARB(int var0, int var1, long var2, long var4);

    @Deprecated
    public static int glGetBufferParameterARB(int target, int pname) {
        return ARBBufferObject.glGetBufferParameteriARB(target, pname);
    }

    public static int glGetBufferParameteriARB(int target, int pname) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glGetBufferParameterivARB;
        BufferChecks.checkFunctionAddress(l);
        IntBuffer intBuffer = APIUtil.getBufferInt(contextCapabilities);
        ARBBufferObject.nglGetBufferParameterivARB(target, pname, MemoryUtil.getAddress(intBuffer), l);
        return intBuffer.get(0);
    }

    public static ByteBuffer glGetBufferPointerARB(int target, int pname) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glGetBufferPointervARB;
        BufferChecks.checkFunctionAddress(l);
        ByteBuffer byteBuffer = ARBBufferObject.nglGetBufferPointervARB(target, pname, GLChecks.getBufferObjectSizeARB(contextCapabilities, target), l);
        return LWJGLUtil.CHECKS && byteBuffer == null ? null : byteBuffer.order(ByteOrder.nativeOrder());
    }

    static native ByteBuffer nglGetBufferPointervARB(int var0, int var1, long var2, long var4);
}

