/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opengl;

import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.nio.ShortBuffer;
import org.lwjgl.BufferChecks;
import org.lwjgl.LWJGLUtil;
import org.lwjgl.MemoryUtil;
import org.lwjgl.opengl.ContextCapabilities;
import org.lwjgl.opengl.GLChecks;
import org.lwjgl.opengl.GLContext;
import org.lwjgl.opengl.StateTracker;

public final class ARBMatrixPalette {
    public static final int GL_MATRIX_PALETTE_ARB = 34880;
    public static final int GL_MAX_MATRIX_PALETTE_STACK_DEPTH_ARB = 34881;
    public static final int GL_MAX_PALETTE_MATRICES_ARB = 34882;
    public static final int GL_CURRENT_PALETTE_MATRIX_ARB = 34883;
    public static final int GL_MATRIX_INDEX_ARRAY_ARB = 34884;
    public static final int GL_CURRENT_MATRIX_INDEX_ARB = 34885;
    public static final int GL_MATRIX_INDEX_ARRAY_SIZE_ARB = 34886;
    public static final int GL_MATRIX_INDEX_ARRAY_TYPE_ARB = 34887;
    public static final int GL_MATRIX_INDEX_ARRAY_STRIDE_ARB = 34888;
    public static final int GL_MATRIX_INDEX_ARRAY_POINTER_ARB = 34889;

    private ARBMatrixPalette() {
    }

    public static void glCurrentPaletteMatrixARB(int index) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glCurrentPaletteMatrixARB;
        BufferChecks.checkFunctionAddress(l);
        ARBMatrixPalette.nglCurrentPaletteMatrixARB(index, l);
    }

    static native void nglCurrentPaletteMatrixARB(int var0, long var1);

    public static void glMatrixIndexPointerARB(int size, int stride, ByteBuffer pPointer) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glMatrixIndexPointerARB;
        BufferChecks.checkFunctionAddress(l);
        GLChecks.ensureArrayVBOdisabled(contextCapabilities);
        BufferChecks.checkDirect(pPointer);
        if (LWJGLUtil.CHECKS) {
            StateTracker.getReferences((ContextCapabilities)contextCapabilities).ARB_matrix_palette_glMatrixIndexPointerARB_pPointer = pPointer;
        }
        ARBMatrixPalette.nglMatrixIndexPointerARB(size, 5121, stride, MemoryUtil.getAddress(pPointer), l);
    }

    public static void glMatrixIndexPointerARB(int size, int stride, IntBuffer pPointer) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glMatrixIndexPointerARB;
        BufferChecks.checkFunctionAddress(l);
        GLChecks.ensureArrayVBOdisabled(contextCapabilities);
        BufferChecks.checkDirect(pPointer);
        if (LWJGLUtil.CHECKS) {
            StateTracker.getReferences((ContextCapabilities)contextCapabilities).ARB_matrix_palette_glMatrixIndexPointerARB_pPointer = pPointer;
        }
        ARBMatrixPalette.nglMatrixIndexPointerARB(size, 5125, stride, MemoryUtil.getAddress(pPointer), l);
    }

    public static void glMatrixIndexPointerARB(int size, int stride, ShortBuffer pPointer) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glMatrixIndexPointerARB;
        BufferChecks.checkFunctionAddress(l);
        GLChecks.ensureArrayVBOdisabled(contextCapabilities);
        BufferChecks.checkDirect(pPointer);
        if (LWJGLUtil.CHECKS) {
            StateTracker.getReferences((ContextCapabilities)contextCapabilities).ARB_matrix_palette_glMatrixIndexPointerARB_pPointer = pPointer;
        }
        ARBMatrixPalette.nglMatrixIndexPointerARB(size, 5123, stride, MemoryUtil.getAddress(pPointer), l);
    }

    static native void nglMatrixIndexPointerARB(int var0, int var1, int var2, long var3, long var5);

    public static void glMatrixIndexPointerARB(int size, int type, int stride, long pPointer_buffer_offset) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glMatrixIndexPointerARB;
        BufferChecks.checkFunctionAddress(l);
        GLChecks.ensureArrayVBOenabled(contextCapabilities);
        ARBMatrixPalette.nglMatrixIndexPointerARBBO(size, type, stride, pPointer_buffer_offset, l);
    }

    static native void nglMatrixIndexPointerARBBO(int var0, int var1, int var2, long var3, long var5);

    public static void glMatrixIndexuARB(ByteBuffer pIndices) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glMatrixIndexubvARB;
        BufferChecks.checkFunctionAddress(l);
        BufferChecks.checkDirect(pIndices);
        ARBMatrixPalette.nglMatrixIndexubvARB(pIndices.remaining(), MemoryUtil.getAddress(pIndices), l);
    }

    static native void nglMatrixIndexubvARB(int var0, long var1, long var3);

    public static void glMatrixIndexuARB(ShortBuffer pIndices) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glMatrixIndexusvARB;
        BufferChecks.checkFunctionAddress(l);
        BufferChecks.checkDirect(pIndices);
        ARBMatrixPalette.nglMatrixIndexusvARB(pIndices.remaining(), MemoryUtil.getAddress(pIndices), l);
    }

    static native void nglMatrixIndexusvARB(int var0, long var1, long var3);

    public static void glMatrixIndexuARB(IntBuffer pIndices) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glMatrixIndexuivARB;
        BufferChecks.checkFunctionAddress(l);
        BufferChecks.checkDirect(pIndices);
        ARBMatrixPalette.nglMatrixIndexuivARB(pIndices.remaining(), MemoryUtil.getAddress(pIndices), l);
    }

    static native void nglMatrixIndexuivARB(int var0, long var1, long var3);
}

