/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opengl;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.ShortBuffer;
import org.lwjgl.BufferChecks;
import org.lwjgl.LWJGLUtil;
import org.lwjgl.MemoryUtil;
import org.lwjgl.PointerBuffer;
import org.lwjgl.opengl.APIUtil;
import org.lwjgl.opengl.ContextCapabilities;
import org.lwjgl.opengl.GLChecks;
import org.lwjgl.opengl.GLContext;
import org.lwjgl.opengl.StateTracker;

public final class GL20 {
    public static final int GL_SHADING_LANGUAGE_VERSION = 35724;
    public static final int GL_CURRENT_PROGRAM = 35725;
    public static final int GL_SHADER_TYPE = 35663;
    public static final int GL_DELETE_STATUS = 35712;
    public static final int GL_COMPILE_STATUS = 35713;
    public static final int GL_LINK_STATUS = 35714;
    public static final int GL_VALIDATE_STATUS = 35715;
    public static final int GL_INFO_LOG_LENGTH = 35716;
    public static final int GL_ATTACHED_SHADERS = 35717;
    public static final int GL_ACTIVE_UNIFORMS = 35718;
    public static final int GL_ACTIVE_UNIFORM_MAX_LENGTH = 35719;
    public static final int GL_ACTIVE_ATTRIBUTES = 35721;
    public static final int GL_ACTIVE_ATTRIBUTE_MAX_LENGTH = 35722;
    public static final int GL_SHADER_SOURCE_LENGTH = 35720;
    public static final int GL_SHADER_OBJECT = 35656;
    public static final int GL_FLOAT_VEC2 = 35664;
    public static final int GL_FLOAT_VEC3 = 35665;
    public static final int GL_FLOAT_VEC4 = 35666;
    public static final int GL_INT_VEC2 = 35667;
    public static final int GL_INT_VEC3 = 35668;
    public static final int GL_INT_VEC4 = 35669;
    public static final int GL_BOOL = 35670;
    public static final int GL_BOOL_VEC2 = 35671;
    public static final int GL_BOOL_VEC3 = 35672;
    public static final int GL_BOOL_VEC4 = 35673;
    public static final int GL_FLOAT_MAT2 = 35674;
    public static final int GL_FLOAT_MAT3 = 35675;
    public static final int GL_FLOAT_MAT4 = 35676;
    public static final int GL_SAMPLER_1D = 35677;
    public static final int GL_SAMPLER_2D = 35678;
    public static final int GL_SAMPLER_3D = 35679;
    public static final int GL_SAMPLER_CUBE = 35680;
    public static final int GL_SAMPLER_1D_SHADOW = 35681;
    public static final int GL_SAMPLER_2D_SHADOW = 35682;
    public static final int GL_VERTEX_SHADER = 35633;
    public static final int GL_MAX_VERTEX_UNIFORM_COMPONENTS = 35658;
    public static final int GL_MAX_VARYING_FLOATS = 35659;
    public static final int GL_MAX_VERTEX_ATTRIBS = 34921;
    public static final int GL_MAX_TEXTURE_IMAGE_UNITS = 34930;
    public static final int GL_MAX_VERTEX_TEXTURE_IMAGE_UNITS = 35660;
    public static final int GL_MAX_COMBINED_TEXTURE_IMAGE_UNITS = 35661;
    public static final int GL_MAX_TEXTURE_COORDS = 34929;
    public static final int GL_VERTEX_PROGRAM_POINT_SIZE = 34370;
    public static final int GL_VERTEX_PROGRAM_TWO_SIDE = 34371;
    public static final int GL_VERTEX_ATTRIB_ARRAY_ENABLED = 34338;
    public static final int GL_VERTEX_ATTRIB_ARRAY_SIZE = 34339;
    public static final int GL_VERTEX_ATTRIB_ARRAY_STRIDE = 34340;
    public static final int GL_VERTEX_ATTRIB_ARRAY_TYPE = 34341;
    public static final int GL_VERTEX_ATTRIB_ARRAY_NORMALIZED = 34922;
    public static final int GL_CURRENT_VERTEX_ATTRIB = 34342;
    public static final int GL_VERTEX_ATTRIB_ARRAY_POINTER = 34373;
    public static final int GL_FRAGMENT_SHADER = 35632;
    public static final int GL_MAX_FRAGMENT_UNIFORM_COMPONENTS = 35657;
    public static final int GL_FRAGMENT_SHADER_DERIVATIVE_HINT = 35723;
    public static final int GL_MAX_DRAW_BUFFERS = 34852;
    public static final int GL_DRAW_BUFFER0 = 34853;
    public static final int GL_DRAW_BUFFER1 = 34854;
    public static final int GL_DRAW_BUFFER2 = 34855;
    public static final int GL_DRAW_BUFFER3 = 34856;
    public static final int GL_DRAW_BUFFER4 = 34857;
    public static final int GL_DRAW_BUFFER5 = 34858;
    public static final int GL_DRAW_BUFFER6 = 34859;
    public static final int GL_DRAW_BUFFER7 = 34860;
    public static final int GL_DRAW_BUFFER8 = 34861;
    public static final int GL_DRAW_BUFFER9 = 34862;
    public static final int GL_DRAW_BUFFER10 = 34863;
    public static final int GL_DRAW_BUFFER11 = 34864;
    public static final int GL_DRAW_BUFFER12 = 34865;
    public static final int GL_DRAW_BUFFER13 = 34866;
    public static final int GL_DRAW_BUFFER14 = 34867;
    public static final int GL_DRAW_BUFFER15 = 34868;
    public static final int GL_POINT_SPRITE = 34913;
    public static final int GL_COORD_REPLACE = 34914;
    public static final int GL_POINT_SPRITE_COORD_ORIGIN = 36000;
    public static final int GL_LOWER_LEFT = 36001;
    public static final int GL_UPPER_LEFT = 36002;
    public static final int GL_STENCIL_BACK_FUNC = 34816;
    public static final int GL_STENCIL_BACK_FAIL = 34817;
    public static final int GL_STENCIL_BACK_PASS_DEPTH_FAIL = 34818;
    public static final int GL_STENCIL_BACK_PASS_DEPTH_PASS = 34819;
    public static final int GL_STENCIL_BACK_REF = 36003;
    public static final int GL_STENCIL_BACK_VALUE_MASK = 36004;
    public static final int GL_STENCIL_BACK_WRITEMASK = 36005;
    public static final int GL_BLEND_EQUATION_RGB = 32777;
    public static final int GL_BLEND_EQUATION_ALPHA = 34877;

    private GL20() {
    }

    public static void glShaderSource(int shader, ByteBuffer string) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glShaderSource;
        BufferChecks.checkFunctionAddress(l);
        BufferChecks.checkDirect(string);
        GL20.nglShaderSource(shader, 1, MemoryUtil.getAddress(string), string.remaining(), l);
    }

    static native void nglShaderSource(int var0, int var1, long var2, int var4, long var5);

    public static void glShaderSource(int shader, CharSequence string) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glShaderSource;
        BufferChecks.checkFunctionAddress(l);
        GL20.nglShaderSource(shader, 1, APIUtil.getBuffer(contextCapabilities, string), string.length(), l);
    }

    public static void glShaderSource(int shader, CharSequence[] strings) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glShaderSource;
        BufferChecks.checkFunctionAddress(l);
        BufferChecks.checkArray(strings);
        GL20.nglShaderSource3(shader, strings.length, APIUtil.getBuffer(contextCapabilities, strings), APIUtil.getLengths(contextCapabilities, strings), l);
    }

    static native void nglShaderSource3(int var0, int var1, long var2, long var4, long var6);

    public static int glCreateShader(int type) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glCreateShader;
        BufferChecks.checkFunctionAddress(l);
        int n = GL20.nglCreateShader(type, l);
        return n;
    }

    static native int nglCreateShader(int var0, long var1);

    public static boolean glIsShader(int shader) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glIsShader;
        BufferChecks.checkFunctionAddress(l);
        boolean bl = GL20.nglIsShader(shader, l);
        return bl;
    }

    static native boolean nglIsShader(int var0, long var1);

    public static void glCompileShader(int shader) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glCompileShader;
        BufferChecks.checkFunctionAddress(l);
        GL20.nglCompileShader(shader, l);
    }

    static native void nglCompileShader(int var0, long var1);

    public static void glDeleteShader(int shader) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glDeleteShader;
        BufferChecks.checkFunctionAddress(l);
        GL20.nglDeleteShader(shader, l);
    }

    static native void nglDeleteShader(int var0, long var1);

    public static int glCreateProgram() {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glCreateProgram;
        BufferChecks.checkFunctionAddress(l);
        int n = GL20.nglCreateProgram(l);
        return n;
    }

    static native int nglCreateProgram(long var0);

    public static boolean glIsProgram(int program) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glIsProgram;
        BufferChecks.checkFunctionAddress(l);
        boolean bl = GL20.nglIsProgram(program, l);
        return bl;
    }

    static native boolean nglIsProgram(int var0, long var1);

    public static void glAttachShader(int program, int shader) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glAttachShader;
        BufferChecks.checkFunctionAddress(l);
        GL20.nglAttachShader(program, shader, l);
    }

    static native void nglAttachShader(int var0, int var1, long var2);

    public static void glDetachShader(int program, int shader) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glDetachShader;
        BufferChecks.checkFunctionAddress(l);
        GL20.nglDetachShader(program, shader, l);
    }

    static native void nglDetachShader(int var0, int var1, long var2);

    public static void glLinkProgram(int program) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glLinkProgram;
        BufferChecks.checkFunctionAddress(l);
        GL20.nglLinkProgram(program, l);
    }

    static native void nglLinkProgram(int var0, long var1);

    public static void glUseProgram(int program) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glUseProgram;
        BufferChecks.checkFunctionAddress(l);
        GL20.nglUseProgram(program, l);
    }

    static native void nglUseProgram(int var0, long var1);

    public static void glValidateProgram(int program) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glValidateProgram;
        BufferChecks.checkFunctionAddress(l);
        GL20.nglValidateProgram(program, l);
    }

    static native void nglValidateProgram(int var0, long var1);

    public static void glDeleteProgram(int program) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glDeleteProgram;
        BufferChecks.checkFunctionAddress(l);
        GL20.nglDeleteProgram(program, l);
    }

    static native void nglDeleteProgram(int var0, long var1);

    public static void glUniform1f(int location, float v0) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glUniform1f;
        BufferChecks.checkFunctionAddress(l);
        GL20.nglUniform1f(location, v0, l);
    }

    static native void nglUniform1f(int var0, float var1, long var2);

    public static void glUniform2f(int location, float v0, float v1) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glUniform2f;
        BufferChecks.checkFunctionAddress(l);
        GL20.nglUniform2f(location, v0, v1, l);
    }

    static native void nglUniform2f(int var0, float var1, float var2, long var3);

    public static void glUniform3f(int location, float v0, float v1, float v2) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glUniform3f;
        BufferChecks.checkFunctionAddress(l);
        GL20.nglUniform3f(location, v0, v1, v2, l);
    }

    static native void nglUniform3f(int var0, float var1, float var2, float var3, long var4);

    public static void glUniform4f(int location, float v0, float v1, float v2, float v3) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glUniform4f;
        BufferChecks.checkFunctionAddress(l);
        GL20.nglUniform4f(location, v0, v1, v2, v3, l);
    }

    static native void nglUniform4f(int var0, float var1, float var2, float var3, float var4, long var5);

    public static void glUniform1i(int location, int v0) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glUniform1i;
        BufferChecks.checkFunctionAddress(l);
        GL20.nglUniform1i(location, v0, l);
    }

    static native void nglUniform1i(int var0, int var1, long var2);

    public static void glUniform2i(int location, int v0, int v1) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glUniform2i;
        BufferChecks.checkFunctionAddress(l);
        GL20.nglUniform2i(location, v0, v1, l);
    }

    static native void nglUniform2i(int var0, int var1, int var2, long var3);

    public static void glUniform3i(int location, int v0, int v1, int v2) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glUniform3i;
        BufferChecks.checkFunctionAddress(l);
        GL20.nglUniform3i(location, v0, v1, v2, l);
    }

    static native void nglUniform3i(int var0, int var1, int var2, int var3, long var4);

    public static void glUniform4i(int location, int v0, int v1, int v2, int v3) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glUniform4i;
        BufferChecks.checkFunctionAddress(l);
        GL20.nglUniform4i(location, v0, v1, v2, v3, l);
    }

    static native void nglUniform4i(int var0, int var1, int var2, int var3, int var4, long var5);

    public static void glUniform1(int location, FloatBuffer values) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glUniform1fv;
        BufferChecks.checkFunctionAddress(l);
        BufferChecks.checkDirect(values);
        GL20.nglUniform1fv(location, values.remaining(), MemoryUtil.getAddress(values), l);
    }

    static native void nglUniform1fv(int var0, int var1, long var2, long var4);

    public static void glUniform2(int location, FloatBuffer values) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glUniform2fv;
        BufferChecks.checkFunctionAddress(l);
        BufferChecks.checkDirect(values);
        GL20.nglUniform2fv(location, values.remaining() >> 1, MemoryUtil.getAddress(values), l);
    }

    static native void nglUniform2fv(int var0, int var1, long var2, long var4);

    public static void glUniform3(int location, FloatBuffer values) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glUniform3fv;
        BufferChecks.checkFunctionAddress(l);
        BufferChecks.checkDirect(values);
        GL20.nglUniform3fv(location, values.remaining() / 3, MemoryUtil.getAddress(values), l);
    }

    static native void nglUniform3fv(int var0, int var1, long var2, long var4);

    public static void glUniform4(int location, FloatBuffer values) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glUniform4fv;
        BufferChecks.checkFunctionAddress(l);
        BufferChecks.checkDirect(values);
        GL20.nglUniform4fv(location, values.remaining() >> 2, MemoryUtil.getAddress(values), l);
    }

    static native void nglUniform4fv(int var0, int var1, long var2, long var4);

    public static void glUniform1(int location, IntBuffer values) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glUniform1iv;
        BufferChecks.checkFunctionAddress(l);
        BufferChecks.checkDirect(values);
        GL20.nglUniform1iv(location, values.remaining(), MemoryUtil.getAddress(values), l);
    }

    static native void nglUniform1iv(int var0, int var1, long var2, long var4);

    public static void glUniform2(int location, IntBuffer values) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glUniform2iv;
        BufferChecks.checkFunctionAddress(l);
        BufferChecks.checkDirect(values);
        GL20.nglUniform2iv(location, values.remaining() >> 1, MemoryUtil.getAddress(values), l);
    }

    static native void nglUniform2iv(int var0, int var1, long var2, long var4);

    public static void glUniform3(int location, IntBuffer values) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glUniform3iv;
        BufferChecks.checkFunctionAddress(l);
        BufferChecks.checkDirect(values);
        GL20.nglUniform3iv(location, values.remaining() / 3, MemoryUtil.getAddress(values), l);
    }

    static native void nglUniform3iv(int var0, int var1, long var2, long var4);

    public static void glUniform4(int location, IntBuffer values) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glUniform4iv;
        BufferChecks.checkFunctionAddress(l);
        BufferChecks.checkDirect(values);
        GL20.nglUniform4iv(location, values.remaining() >> 2, MemoryUtil.getAddress(values), l);
    }

    static native void nglUniform4iv(int var0, int var1, long var2, long var4);

    public static void glUniformMatrix2(int location, boolean transpose, FloatBuffer matrices) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glUniformMatrix2fv;
        BufferChecks.checkFunctionAddress(l);
        BufferChecks.checkDirect(matrices);
        GL20.nglUniformMatrix2fv(location, matrices.remaining() >> 2, transpose, MemoryUtil.getAddress(matrices), l);
    }

    static native void nglUniformMatrix2fv(int var0, int var1, boolean var2, long var3, long var5);

    public static void glUniformMatrix3(int location, boolean transpose, FloatBuffer matrices) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glUniformMatrix3fv;
        BufferChecks.checkFunctionAddress(l);
        BufferChecks.checkDirect(matrices);
        GL20.nglUniformMatrix3fv(location, matrices.remaining() / 9, transpose, MemoryUtil.getAddress(matrices), l);
    }

    static native void nglUniformMatrix3fv(int var0, int var1, boolean var2, long var3, long var5);

    public static void glUniformMatrix4(int location, boolean transpose, FloatBuffer matrices) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glUniformMatrix4fv;
        BufferChecks.checkFunctionAddress(l);
        BufferChecks.checkDirect(matrices);
        GL20.nglUniformMatrix4fv(location, matrices.remaining() >> 4, transpose, MemoryUtil.getAddress(matrices), l);
    }

    static native void nglUniformMatrix4fv(int var0, int var1, boolean var2, long var3, long var5);

    public static void glGetShader(int shader, int pname, IntBuffer params) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glGetShaderiv;
        BufferChecks.checkFunctionAddress(l);
        BufferChecks.checkDirect(params);
        GL20.nglGetShaderiv(shader, pname, MemoryUtil.getAddress(params), l);
    }

    static native void nglGetShaderiv(int var0, int var1, long var2, long var4);

    @Deprecated
    public static int glGetShader(int shader, int pname) {
        return GL20.glGetShaderi(shader, pname);
    }

    public static int glGetShaderi(int shader, int pname) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glGetShaderiv;
        BufferChecks.checkFunctionAddress(l);
        IntBuffer intBuffer = APIUtil.getBufferInt(contextCapabilities);
        GL20.nglGetShaderiv(shader, pname, MemoryUtil.getAddress(intBuffer), l);
        return intBuffer.get(0);
    }

    public static void glGetProgram(int program, int pname, IntBuffer params) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glGetProgramiv;
        BufferChecks.checkFunctionAddress(l);
        BufferChecks.checkDirect(params);
        GL20.nglGetProgramiv(program, pname, MemoryUtil.getAddress(params), l);
    }

    static native void nglGetProgramiv(int var0, int var1, long var2, long var4);

    @Deprecated
    public static int glGetProgram(int program, int pname) {
        return GL20.glGetProgrami(program, pname);
    }

    public static int glGetProgrami(int program, int pname) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glGetProgramiv;
        BufferChecks.checkFunctionAddress(l);
        IntBuffer intBuffer = APIUtil.getBufferInt(contextCapabilities);
        GL20.nglGetProgramiv(program, pname, MemoryUtil.getAddress(intBuffer), l);
        return intBuffer.get(0);
    }

    public static void glGetShaderInfoLog(int shader, IntBuffer length, ByteBuffer infoLog) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glGetShaderInfoLog;
        BufferChecks.checkFunctionAddress(l);
        if (length != null) {
            BufferChecks.checkBuffer(length, 1);
        }
        BufferChecks.checkDirect(infoLog);
        GL20.nglGetShaderInfoLog(shader, infoLog.remaining(), MemoryUtil.getAddressSafe(length), MemoryUtil.getAddress(infoLog), l);
    }

    static native void nglGetShaderInfoLog(int var0, int var1, long var2, long var4, long var6);

    public static String glGetShaderInfoLog(int shader, int maxLength) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glGetShaderInfoLog;
        BufferChecks.checkFunctionAddress(l);
        IntBuffer intBuffer = APIUtil.getLengths(contextCapabilities);
        ByteBuffer byteBuffer = APIUtil.getBufferByte(contextCapabilities, maxLength);
        GL20.nglGetShaderInfoLog(shader, maxLength, MemoryUtil.getAddress0(intBuffer), MemoryUtil.getAddress(byteBuffer), l);
        byteBuffer.limit(intBuffer.get(0));
        return APIUtil.getString(contextCapabilities, byteBuffer);
    }

    public static void glGetProgramInfoLog(int program, IntBuffer length, ByteBuffer infoLog) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glGetProgramInfoLog;
        BufferChecks.checkFunctionAddress(l);
        if (length != null) {
            BufferChecks.checkBuffer(length, 1);
        }
        BufferChecks.checkDirect(infoLog);
        GL20.nglGetProgramInfoLog(program, infoLog.remaining(), MemoryUtil.getAddressSafe(length), MemoryUtil.getAddress(infoLog), l);
    }

    static native void nglGetProgramInfoLog(int var0, int var1, long var2, long var4, long var6);

    public static String glGetProgramInfoLog(int program, int maxLength) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glGetProgramInfoLog;
        BufferChecks.checkFunctionAddress(l);
        IntBuffer intBuffer = APIUtil.getLengths(contextCapabilities);
        ByteBuffer byteBuffer = APIUtil.getBufferByte(contextCapabilities, maxLength);
        GL20.nglGetProgramInfoLog(program, maxLength, MemoryUtil.getAddress0(intBuffer), MemoryUtil.getAddress(byteBuffer), l);
        byteBuffer.limit(intBuffer.get(0));
        return APIUtil.getString(contextCapabilities, byteBuffer);
    }

    public static void glGetAttachedShaders(int program, IntBuffer count, IntBuffer shaders) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glGetAttachedShaders;
        BufferChecks.checkFunctionAddress(l);
        if (count != null) {
            BufferChecks.checkBuffer(count, 1);
        }
        BufferChecks.checkDirect(shaders);
        GL20.nglGetAttachedShaders(program, shaders.remaining(), MemoryUtil.getAddressSafe(count), MemoryUtil.getAddress(shaders), l);
    }

    static native void nglGetAttachedShaders(int var0, int var1, long var2, long var4, long var6);

    public static int glGetUniformLocation(int program, ByteBuffer name) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glGetUniformLocation;
        BufferChecks.checkFunctionAddress(l);
        BufferChecks.checkBuffer(name, 1);
        BufferChecks.checkNullTerminated(name);
        int n = GL20.nglGetUniformLocation(program, MemoryUtil.getAddress(name), l);
        return n;
    }

    static native int nglGetUniformLocation(int var0, long var1, long var3);

    public static int glGetUniformLocation(int program, CharSequence name) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glGetUniformLocation;
        BufferChecks.checkFunctionAddress(l);
        int n = GL20.nglGetUniformLocation(program, APIUtil.getBufferNT(contextCapabilities, name), l);
        return n;
    }

    public static void glGetActiveUniform(int program, int index, IntBuffer length, IntBuffer size, IntBuffer type, ByteBuffer name) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glGetActiveUniform;
        BufferChecks.checkFunctionAddress(l);
        if (length != null) {
            BufferChecks.checkBuffer(length, 1);
        }
        BufferChecks.checkBuffer(size, 1);
        BufferChecks.checkBuffer(type, 1);
        BufferChecks.checkDirect(name);
        GL20.nglGetActiveUniform(program, index, name.remaining(), MemoryUtil.getAddressSafe(length), MemoryUtil.getAddress(size), MemoryUtil.getAddress(type), MemoryUtil.getAddress(name), l);
    }

    static native void nglGetActiveUniform(int var0, int var1, int var2, long var3, long var5, long var7, long var9, long var11);

    public static String glGetActiveUniform(int program, int index, int maxLength, IntBuffer sizeType) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glGetActiveUniform;
        BufferChecks.checkFunctionAddress(l);
        BufferChecks.checkBuffer(sizeType, 2);
        IntBuffer intBuffer = APIUtil.getLengths(contextCapabilities);
        ByteBuffer byteBuffer = APIUtil.getBufferByte(contextCapabilities, maxLength);
        GL20.nglGetActiveUniform(program, index, maxLength, MemoryUtil.getAddress0(intBuffer), MemoryUtil.getAddress(sizeType), MemoryUtil.getAddress(sizeType, sizeType.position() + 1), MemoryUtil.getAddress(byteBuffer), l);
        byteBuffer.limit(intBuffer.get(0));
        return APIUtil.getString(contextCapabilities, byteBuffer);
    }

    public static String glGetActiveUniform(int program, int index, int maxLength) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glGetActiveUniform;
        BufferChecks.checkFunctionAddress(l);
        IntBuffer intBuffer = APIUtil.getLengths(contextCapabilities);
        ByteBuffer byteBuffer = APIUtil.getBufferByte(contextCapabilities, maxLength);
        GL20.nglGetActiveUniform(program, index, maxLength, MemoryUtil.getAddress0(intBuffer), MemoryUtil.getAddress0(APIUtil.getBufferInt(contextCapabilities)), MemoryUtil.getAddress(APIUtil.getBufferInt(contextCapabilities), 1), MemoryUtil.getAddress(byteBuffer), l);
        byteBuffer.limit(intBuffer.get(0));
        return APIUtil.getString(contextCapabilities, byteBuffer);
    }

    public static int glGetActiveUniformSize(int program, int index) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glGetActiveUniform;
        BufferChecks.checkFunctionAddress(l);
        IntBuffer intBuffer = APIUtil.getBufferInt(contextCapabilities);
        GL20.nglGetActiveUniform(program, index, 1, 0L, MemoryUtil.getAddress(intBuffer), MemoryUtil.getAddress(intBuffer, 1), APIUtil.getBufferByte0(contextCapabilities), l);
        return intBuffer.get(0);
    }

    public static int glGetActiveUniformType(int program, int index) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glGetActiveUniform;
        BufferChecks.checkFunctionAddress(l);
        IntBuffer intBuffer = APIUtil.getBufferInt(contextCapabilities);
        GL20.nglGetActiveUniform(program, index, 0, 0L, MemoryUtil.getAddress(intBuffer, 1), MemoryUtil.getAddress(intBuffer), APIUtil.getBufferByte0(contextCapabilities), l);
        return intBuffer.get(0);
    }

    public static void glGetUniform(int program, int location, FloatBuffer params) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glGetUniformfv;
        BufferChecks.checkFunctionAddress(l);
        BufferChecks.checkDirect(params);
        GL20.nglGetUniformfv(program, location, MemoryUtil.getAddress(params), l);
    }

    static native void nglGetUniformfv(int var0, int var1, long var2, long var4);

    public static void glGetUniform(int program, int location, IntBuffer params) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glGetUniformiv;
        BufferChecks.checkFunctionAddress(l);
        BufferChecks.checkDirect(params);
        GL20.nglGetUniformiv(program, location, MemoryUtil.getAddress(params), l);
    }

    static native void nglGetUniformiv(int var0, int var1, long var2, long var4);

    public static void glGetShaderSource(int shader, IntBuffer length, ByteBuffer source) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glGetShaderSource;
        BufferChecks.checkFunctionAddress(l);
        if (length != null) {
            BufferChecks.checkBuffer(length, 1);
        }
        BufferChecks.checkDirect(source);
        GL20.nglGetShaderSource(shader, source.remaining(), MemoryUtil.getAddressSafe(length), MemoryUtil.getAddress(source), l);
    }

    static native void nglGetShaderSource(int var0, int var1, long var2, long var4, long var6);

    public static String glGetShaderSource(int shader, int maxLength) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glGetShaderSource;
        BufferChecks.checkFunctionAddress(l);
        IntBuffer intBuffer = APIUtil.getLengths(contextCapabilities);
        ByteBuffer byteBuffer = APIUtil.getBufferByte(contextCapabilities, maxLength);
        GL20.nglGetShaderSource(shader, maxLength, MemoryUtil.getAddress0(intBuffer), MemoryUtil.getAddress(byteBuffer), l);
        byteBuffer.limit(intBuffer.get(0));
        return APIUtil.getString(contextCapabilities, byteBuffer);
    }

    public static void glVertexAttrib1s(int index, short x) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glVertexAttrib1s;
        BufferChecks.checkFunctionAddress(l);
        GL20.nglVertexAttrib1s(index, x, l);
    }

    static native void nglVertexAttrib1s(int var0, short var1, long var2);

    public static void glVertexAttrib1f(int index, float x) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glVertexAttrib1f;
        BufferChecks.checkFunctionAddress(l);
        GL20.nglVertexAttrib1f(index, x, l);
    }

    static native void nglVertexAttrib1f(int var0, float var1, long var2);

    public static void glVertexAttrib1d(int index, double x) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glVertexAttrib1d;
        BufferChecks.checkFunctionAddress(l);
        GL20.nglVertexAttrib1d(index, x, l);
    }

    static native void nglVertexAttrib1d(int var0, double var1, long var3);

    public static void glVertexAttrib2s(int index, short x, short y) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glVertexAttrib2s;
        BufferChecks.checkFunctionAddress(l);
        GL20.nglVertexAttrib2s(index, x, y, l);
    }

    static native void nglVertexAttrib2s(int var0, short var1, short var2, long var3);

    public static void glVertexAttrib2f(int index, float x, float y) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glVertexAttrib2f;
        BufferChecks.checkFunctionAddress(l);
        GL20.nglVertexAttrib2f(index, x, y, l);
    }

    static native void nglVertexAttrib2f(int var0, float var1, float var2, long var3);

    public static void glVertexAttrib2d(int index, double x, double y) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glVertexAttrib2d;
        BufferChecks.checkFunctionAddress(l);
        GL20.nglVertexAttrib2d(index, x, y, l);
    }

    static native void nglVertexAttrib2d(int var0, double var1, double var3, long var5);

    public static void glVertexAttrib3s(int index, short x, short y, short z) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glVertexAttrib3s;
        BufferChecks.checkFunctionAddress(l);
        GL20.nglVertexAttrib3s(index, x, y, z, l);
    }

    static native void nglVertexAttrib3s(int var0, short var1, short var2, short var3, long var4);

    public static void glVertexAttrib3f(int index, float x, float y, float z) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glVertexAttrib3f;
        BufferChecks.checkFunctionAddress(l);
        GL20.nglVertexAttrib3f(index, x, y, z, l);
    }

    static native void nglVertexAttrib3f(int var0, float var1, float var2, float var3, long var4);

    public static void glVertexAttrib3d(int index, double x, double y, double z) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glVertexAttrib3d;
        BufferChecks.checkFunctionAddress(l);
        GL20.nglVertexAttrib3d(index, x, y, z, l);
    }

    static native void nglVertexAttrib3d(int var0, double var1, double var3, double var5, long var7);

    public static void glVertexAttrib4s(int index, short x, short y, short z, short w) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glVertexAttrib4s;
        BufferChecks.checkFunctionAddress(l);
        GL20.nglVertexAttrib4s(index, x, y, z, w, l);
    }

    static native void nglVertexAttrib4s(int var0, short var1, short var2, short var3, short var4, long var5);

    public static void glVertexAttrib4f(int index, float x, float y, float z, float w) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glVertexAttrib4f;
        BufferChecks.checkFunctionAddress(l);
        GL20.nglVertexAttrib4f(index, x, y, z, w, l);
    }

    static native void nglVertexAttrib4f(int var0, float var1, float var2, float var3, float var4, long var5);

    public static void glVertexAttrib4d(int index, double x, double y, double z, double w) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glVertexAttrib4d;
        BufferChecks.checkFunctionAddress(l);
        GL20.nglVertexAttrib4d(index, x, y, z, w, l);
    }

    static native void nglVertexAttrib4d(int var0, double var1, double var3, double var5, double var7, long var9);

    public static void glVertexAttrib4Nub(int index, byte x, byte y, byte z, byte w) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glVertexAttrib4Nub;
        BufferChecks.checkFunctionAddress(l);
        GL20.nglVertexAttrib4Nub(index, x, y, z, w, l);
    }

    static native void nglVertexAttrib4Nub(int var0, byte var1, byte var2, byte var3, byte var4, long var5);

    public static void glVertexAttribPointer(int index, int size, boolean normalized, int stride, DoubleBuffer buffer) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glVertexAttribPointer;
        BufferChecks.checkFunctionAddress(l);
        GLChecks.ensureArrayVBOdisabled(contextCapabilities);
        BufferChecks.checkDirect(buffer);
        if (LWJGLUtil.CHECKS) {
            StateTracker.getReferences((ContextCapabilities)contextCapabilities).glVertexAttribPointer_buffer[index] = buffer;
        }
        GL20.nglVertexAttribPointer(index, size, 5130, normalized, stride, MemoryUtil.getAddress(buffer), l);
    }

    public static void glVertexAttribPointer(int index, int size, boolean normalized, int stride, FloatBuffer buffer) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glVertexAttribPointer;
        BufferChecks.checkFunctionAddress(l);
        GLChecks.ensureArrayVBOdisabled(contextCapabilities);
        BufferChecks.checkDirect(buffer);
        if (LWJGLUtil.CHECKS) {
            StateTracker.getReferences((ContextCapabilities)contextCapabilities).glVertexAttribPointer_buffer[index] = buffer;
        }
        GL20.nglVertexAttribPointer(index, size, 5126, normalized, stride, MemoryUtil.getAddress(buffer), l);
    }

    public static void glVertexAttribPointer(int index, int size, boolean unsigned, boolean normalized, int stride, ByteBuffer buffer) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glVertexAttribPointer;
        BufferChecks.checkFunctionAddress(l);
        GLChecks.ensureArrayVBOdisabled(contextCapabilities);
        BufferChecks.checkDirect(buffer);
        if (LWJGLUtil.CHECKS) {
            StateTracker.getReferences((ContextCapabilities)contextCapabilities).glVertexAttribPointer_buffer[index] = buffer;
        }
        GL20.nglVertexAttribPointer(index, size, unsigned ? 5121 : 5120, normalized, stride, MemoryUtil.getAddress(buffer), l);
    }

    public static void glVertexAttribPointer(int index, int size, boolean unsigned, boolean normalized, int stride, IntBuffer buffer) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glVertexAttribPointer;
        BufferChecks.checkFunctionAddress(l);
        GLChecks.ensureArrayVBOdisabled(contextCapabilities);
        BufferChecks.checkDirect(buffer);
        if (LWJGLUtil.CHECKS) {
            StateTracker.getReferences((ContextCapabilities)contextCapabilities).glVertexAttribPointer_buffer[index] = buffer;
        }
        GL20.nglVertexAttribPointer(index, size, unsigned ? 5125 : 5124, normalized, stride, MemoryUtil.getAddress(buffer), l);
    }

    public static void glVertexAttribPointer(int index, int size, boolean unsigned, boolean normalized, int stride, ShortBuffer buffer) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glVertexAttribPointer;
        BufferChecks.checkFunctionAddress(l);
        GLChecks.ensureArrayVBOdisabled(contextCapabilities);
        BufferChecks.checkDirect(buffer);
        if (LWJGLUtil.CHECKS) {
            StateTracker.getReferences((ContextCapabilities)contextCapabilities).glVertexAttribPointer_buffer[index] = buffer;
        }
        GL20.nglVertexAttribPointer(index, size, unsigned ? 5123 : 5122, normalized, stride, MemoryUtil.getAddress(buffer), l);
    }

    static native void nglVertexAttribPointer(int var0, int var1, int var2, boolean var3, int var4, long var5, long var7);

    public static void glVertexAttribPointer(int index, int size, int type, boolean normalized, int stride, long buffer_buffer_offset) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glVertexAttribPointer;
        BufferChecks.checkFunctionAddress(l);
        GLChecks.ensureArrayVBOenabled(contextCapabilities);
        GL20.nglVertexAttribPointerBO(index, size, type, normalized, stride, buffer_buffer_offset, l);
    }

    static native void nglVertexAttribPointerBO(int var0, int var1, int var2, boolean var3, int var4, long var5, long var7);

    public static void glVertexAttribPointer(int index, int size, int type, boolean normalized, int stride, ByteBuffer buffer) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glVertexAttribPointer;
        BufferChecks.checkFunctionAddress(l);
        GLChecks.ensureArrayVBOdisabled(contextCapabilities);
        BufferChecks.checkDirect(buffer);
        if (LWJGLUtil.CHECKS) {
            StateTracker.getReferences((ContextCapabilities)contextCapabilities).glVertexAttribPointer_buffer[index] = buffer;
        }
        GL20.nglVertexAttribPointer(index, size, type, normalized, stride, MemoryUtil.getAddress(buffer), l);
    }

    public static void glEnableVertexAttribArray(int index) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glEnableVertexAttribArray;
        BufferChecks.checkFunctionAddress(l);
        GL20.nglEnableVertexAttribArray(index, l);
    }

    static native void nglEnableVertexAttribArray(int var0, long var1);

    public static void glDisableVertexAttribArray(int index) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glDisableVertexAttribArray;
        BufferChecks.checkFunctionAddress(l);
        GL20.nglDisableVertexAttribArray(index, l);
    }

    static native void nglDisableVertexAttribArray(int var0, long var1);

    public static void glGetVertexAttrib(int index, int pname, FloatBuffer params) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glGetVertexAttribfv;
        BufferChecks.checkFunctionAddress(l);
        BufferChecks.checkBuffer(params, 4);
        GL20.nglGetVertexAttribfv(index, pname, MemoryUtil.getAddress(params), l);
    }

    static native void nglGetVertexAttribfv(int var0, int var1, long var2, long var4);

    public static void glGetVertexAttrib(int index, int pname, DoubleBuffer params) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glGetVertexAttribdv;
        BufferChecks.checkFunctionAddress(l);
        BufferChecks.checkBuffer(params, 4);
        GL20.nglGetVertexAttribdv(index, pname, MemoryUtil.getAddress(params), l);
    }

    static native void nglGetVertexAttribdv(int var0, int var1, long var2, long var4);

    public static void glGetVertexAttrib(int index, int pname, IntBuffer params) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glGetVertexAttribiv;
        BufferChecks.checkFunctionAddress(l);
        BufferChecks.checkBuffer(params, 4);
        GL20.nglGetVertexAttribiv(index, pname, MemoryUtil.getAddress(params), l);
    }

    static native void nglGetVertexAttribiv(int var0, int var1, long var2, long var4);

    public static ByteBuffer glGetVertexAttribPointer(int index, int pname, long result_size) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glGetVertexAttribPointerv;
        BufferChecks.checkFunctionAddress(l);
        ByteBuffer byteBuffer = GL20.nglGetVertexAttribPointerv(index, pname, result_size, l);
        return LWJGLUtil.CHECKS && byteBuffer == null ? null : byteBuffer.order(ByteOrder.nativeOrder());
    }

    static native ByteBuffer nglGetVertexAttribPointerv(int var0, int var1, long var2, long var4);

    public static void glGetVertexAttribPointer(int index, int pname, ByteBuffer pointer) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glGetVertexAttribPointerv;
        BufferChecks.checkFunctionAddress(l);
        BufferChecks.checkBuffer(pointer, PointerBuffer.getPointerSize());
        GL20.nglGetVertexAttribPointerv2(index, pname, MemoryUtil.getAddress(pointer), l);
    }

    static native void nglGetVertexAttribPointerv2(int var0, int var1, long var2, long var4);

    public static void glBindAttribLocation(int program, int index, ByteBuffer name) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glBindAttribLocation;
        BufferChecks.checkFunctionAddress(l);
        BufferChecks.checkDirect(name);
        BufferChecks.checkNullTerminated(name);
        GL20.nglBindAttribLocation(program, index, MemoryUtil.getAddress(name), l);
    }

    static native void nglBindAttribLocation(int var0, int var1, long var2, long var4);

    public static void glBindAttribLocation(int program, int index, CharSequence name) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glBindAttribLocation;
        BufferChecks.checkFunctionAddress(l);
        GL20.nglBindAttribLocation(program, index, APIUtil.getBufferNT(contextCapabilities, name), l);
    }

    public static void glGetActiveAttrib(int program, int index, IntBuffer length, IntBuffer size, IntBuffer type, ByteBuffer name) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glGetActiveAttrib;
        BufferChecks.checkFunctionAddress(l);
        if (length != null) {
            BufferChecks.checkBuffer(length, 1);
        }
        BufferChecks.checkBuffer(size, 1);
        BufferChecks.checkBuffer(type, 1);
        BufferChecks.checkDirect(name);
        GL20.nglGetActiveAttrib(program, index, name.remaining(), MemoryUtil.getAddressSafe(length), MemoryUtil.getAddress(size), MemoryUtil.getAddress(type), MemoryUtil.getAddress(name), l);
    }

    static native void nglGetActiveAttrib(int var0, int var1, int var2, long var3, long var5, long var7, long var9, long var11);

    public static String glGetActiveAttrib(int program, int index, int maxLength, IntBuffer sizeType) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glGetActiveAttrib;
        BufferChecks.checkFunctionAddress(l);
        BufferChecks.checkBuffer(sizeType, 2);
        IntBuffer intBuffer = APIUtil.getLengths(contextCapabilities);
        ByteBuffer byteBuffer = APIUtil.getBufferByte(contextCapabilities, maxLength);
        GL20.nglGetActiveAttrib(program, index, maxLength, MemoryUtil.getAddress0(intBuffer), MemoryUtil.getAddress(sizeType), MemoryUtil.getAddress(sizeType, sizeType.position() + 1), MemoryUtil.getAddress(byteBuffer), l);
        byteBuffer.limit(intBuffer.get(0));
        return APIUtil.getString(contextCapabilities, byteBuffer);
    }

    public static String glGetActiveAttrib(int program, int index, int maxLength) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glGetActiveAttrib;
        BufferChecks.checkFunctionAddress(l);
        IntBuffer intBuffer = APIUtil.getLengths(contextCapabilities);
        ByteBuffer byteBuffer = APIUtil.getBufferByte(contextCapabilities, maxLength);
        GL20.nglGetActiveAttrib(program, index, maxLength, MemoryUtil.getAddress0(intBuffer), MemoryUtil.getAddress0(APIUtil.getBufferInt(contextCapabilities)), MemoryUtil.getAddress(APIUtil.getBufferInt(contextCapabilities), 1), MemoryUtil.getAddress(byteBuffer), l);
        byteBuffer.limit(intBuffer.get(0));
        return APIUtil.getString(contextCapabilities, byteBuffer);
    }

    public static int glGetActiveAttribSize(int program, int index) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glGetActiveAttrib;
        BufferChecks.checkFunctionAddress(l);
        IntBuffer intBuffer = APIUtil.getBufferInt(contextCapabilities);
        GL20.nglGetActiveAttrib(program, index, 0, 0L, MemoryUtil.getAddress(intBuffer), MemoryUtil.getAddress(intBuffer, 1), APIUtil.getBufferByte0(contextCapabilities), l);
        return intBuffer.get(0);
    }

    public static int glGetActiveAttribType(int program, int index) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glGetActiveAttrib;
        BufferChecks.checkFunctionAddress(l);
        IntBuffer intBuffer = APIUtil.getBufferInt(contextCapabilities);
        GL20.nglGetActiveAttrib(program, index, 0, 0L, MemoryUtil.getAddress(intBuffer, 1), MemoryUtil.getAddress(intBuffer), APIUtil.getBufferByte0(contextCapabilities), l);
        return intBuffer.get(0);
    }

    public static int glGetAttribLocation(int program, ByteBuffer name) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glGetAttribLocation;
        BufferChecks.checkFunctionAddress(l);
        BufferChecks.checkDirect(name);
        BufferChecks.checkNullTerminated(name);
        int n = GL20.nglGetAttribLocation(program, MemoryUtil.getAddress(name), l);
        return n;
    }

    static native int nglGetAttribLocation(int var0, long var1, long var3);

    public static int glGetAttribLocation(int program, CharSequence name) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glGetAttribLocation;
        BufferChecks.checkFunctionAddress(l);
        int n = GL20.nglGetAttribLocation(program, APIUtil.getBufferNT(contextCapabilities, name), l);
        return n;
    }

    public static void glDrawBuffers(IntBuffer buffers) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glDrawBuffers;
        BufferChecks.checkFunctionAddress(l);
        BufferChecks.checkDirect(buffers);
        GL20.nglDrawBuffers(buffers.remaining(), MemoryUtil.getAddress(buffers), l);
    }

    static native void nglDrawBuffers(int var0, long var1, long var3);

    public static void glDrawBuffers(int buffer) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glDrawBuffers;
        BufferChecks.checkFunctionAddress(l);
        GL20.nglDrawBuffers(1, APIUtil.getInt(contextCapabilities, buffer), l);
    }

    public static void glStencilOpSeparate(int face, int sfail, int dpfail, int dppass) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glStencilOpSeparate;
        BufferChecks.checkFunctionAddress(l);
        GL20.nglStencilOpSeparate(face, sfail, dpfail, dppass, l);
    }

    static native void nglStencilOpSeparate(int var0, int var1, int var2, int var3, long var4);

    public static void glStencilFuncSeparate(int face, int func, int ref, int mask) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glStencilFuncSeparate;
        BufferChecks.checkFunctionAddress(l);
        GL20.nglStencilFuncSeparate(face, func, ref, mask, l);
    }

    static native void nglStencilFuncSeparate(int var0, int var1, int var2, int var3, long var4);

    public static void glStencilMaskSeparate(int face, int mask) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glStencilMaskSeparate;
        BufferChecks.checkFunctionAddress(l);
        GL20.nglStencilMaskSeparate(face, mask, l);
    }

    static native void nglStencilMaskSeparate(int var0, int var1, long var2);

    public static void glBlendEquationSeparate(int modeRGB, int modeAlpha) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glBlendEquationSeparate;
        BufferChecks.checkFunctionAddress(l);
        GL20.nglBlendEquationSeparate(modeRGB, modeAlpha, l);
    }

    static native void nglBlendEquationSeparate(int var0, int var1, long var2);
}

