/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opengl;

import java.applet.Applet;
import java.awt.Canvas;
import java.awt.Container;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.ComponentListener;
import java.nio.ByteBuffer;
import javax.swing.SwingUtilities;
import org.lwjgl.opengl.AWTSurfaceLock;
import org.lwjgl.opengl.ContextAttribs;
import org.lwjgl.opengl.MacOSXCanvasPeerInfo$1;
import org.lwjgl.opengl.MacOSXPeerInfo;
import org.lwjgl.opengl.PixelFormat;

abstract class MacOSXCanvasPeerInfo
extends MacOSXPeerInfo {
    private final AWTSurfaceLock awt_surface = new AWTSurfaceLock();
    public ByteBuffer window_handle;

    protected MacOSXCanvasPeerInfo(PixelFormat pixel_format, ContextAttribs attribs, boolean support_pbuffer) {
        super(pixel_format, attribs, true, true, support_pbuffer, true);
    }

    protected void initHandle(Canvas component) {
        boolean bl = true;
        boolean bl2 = true;
        String string = System.getProperty("java.version");
        if (string.startsWith("1.5") || string.startsWith("1.6")) {
            bl = false;
        } else if (string.startsWith("1.7")) {
            bl2 = false;
        }
        Insets insets = this.getInsets(component);
        int n = insets != null ? insets.top : 0;
        int n2 = insets != null ? insets.left : 0;
        this.window_handle = MacOSXCanvasPeerInfo.nInitHandle(this.awt_surface.lockAndGetHandle(component), this.getHandle(), this.window_handle, bl, bl2, component.getX() - n2, component.getY() - n);
        if (string.startsWith("1.7")) {
            this.addComponentListener(component);
            if (SwingUtilities.getWindowAncestor(component.getParent()) != null) {
                Point point = SwingUtilities.convertPoint(component, component.getLocation(), null);
                Point point2 = SwingUtilities.convertPoint(component.getParent(), component.getLocation(), null);
                if (point.getX() == point2.getX() && point.getY() == point2.getY()) {
                    insets = this.getWindowInsets(component);
                    n = insets != null ? insets.top : 0;
                    n2 = insets != null ? insets.left : 0;
                    int n3 = (int)point.getX() - n2;
                    int n4 = (int)(-point.getY()) + n - component.getHeight();
                    int n5 = component.getWidth();
                    int n6 = component.getHeight();
                    MacOSXCanvasPeerInfo.nSetLayerBounds(this.getHandle(), n3, n4, n5, n6);
                }
            }
        }
    }

    private void addComponentListener(Canvas component) {
        ComponentListener[] componentListenerArray = component.getComponentListeners();
        for (int i = 0; i < componentListenerArray.length; ++i) {
            ComponentListener componentListener = componentListenerArray[i];
            if (componentListener.toString() != "CanvasPeerInfoListener") continue;
            return;
        }
        MacOSXCanvasPeerInfo$1 macOSXCanvasPeerInfo$1 = new MacOSXCanvasPeerInfo$1(this, component);
        component.addComponentListener(macOSXCanvasPeerInfo$1);
    }

    private static native ByteBuffer nInitHandle(ByteBuffer var0, ByteBuffer var1, ByteBuffer var2, boolean var3, boolean var4, int var5, int var6);

    private static native void nSetLayerPosition(ByteBuffer var0, int var1, int var2);

    private static native void nSetLayerBounds(ByteBuffer var0, int var1, int var2, int var3, int var4);

    @Override
    protected void doUnlock() {
        this.awt_surface.unlock();
    }

    private Insets getWindowInsets(Canvas canvas) {
        for (Container container = canvas.getParent(); container != null; container = container.getParent()) {
            if (!(container instanceof Window) && !(container instanceof Applet)) continue;
            return container.getInsets();
        }
        return null;
    }

    private Insets getInsets(Canvas component) {
        for (Container container = component.getParent(); container != null; container = container.getParent()) {
            if (!(container instanceof Container)) continue;
            return container.getInsets();
        }
        return null;
    }

    static /* synthetic */ Insets access$000(MacOSXCanvasPeerInfo x0, Canvas x1) {
        return x0.getWindowInsets(x1);
    }

    static /* synthetic */ void access$100(ByteBuffer x0, int x1, int x2, int x3, int x4) {
        MacOSXCanvasPeerInfo.nSetLayerBounds(x0, x1, x2, x3, x4);
    }

    static /* synthetic */ Insets access$200(MacOSXCanvasPeerInfo x0, Canvas x1) {
        return x0.getInsets(x1);
    }
}

