/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opengl;

import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import org.lwjgl.BufferChecks;
import org.lwjgl.MemoryUtil;
import org.lwjgl.opengl.APIUtil;
import org.lwjgl.opengl.ContextCapabilities;
import org.lwjgl.opengl.GLContext;

public class NVProgram {
    public static final int GL_PROGRAM_TARGET_NV = 34374;
    public static final int GL_PROGRAM_LENGTH_NV = 34343;
    public static final int GL_PROGRAM_RESIDENT_NV = 34375;
    public static final int GL_PROGRAM_STRING_NV = 34344;
    public static final int GL_PROGRAM_ERROR_POSITION_NV = 34379;
    public static final int GL_PROGRAM_ERROR_STRING_NV = 34932;

    public static void glLoadProgramNV(int target, int programID, ByteBuffer string) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glLoadProgramNV;
        BufferChecks.checkFunctionAddress(l);
        BufferChecks.checkDirect(string);
        NVProgram.nglLoadProgramNV(target, programID, string.remaining(), MemoryUtil.getAddress(string), l);
    }

    static native void nglLoadProgramNV(int var0, int var1, int var2, long var3, long var5);

    public static void glLoadProgramNV(int target, int programID, CharSequence string) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glLoadProgramNV;
        BufferChecks.checkFunctionAddress(l);
        NVProgram.nglLoadProgramNV(target, programID, string.length(), APIUtil.getBuffer(contextCapabilities, string), l);
    }

    public static void glBindProgramNV(int target, int programID) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glBindProgramNV;
        BufferChecks.checkFunctionAddress(l);
        NVProgram.nglBindProgramNV(target, programID, l);
    }

    static native void nglBindProgramNV(int var0, int var1, long var2);

    public static void glDeleteProgramsNV(IntBuffer programs) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glDeleteProgramsNV;
        BufferChecks.checkFunctionAddress(l);
        BufferChecks.checkDirect(programs);
        NVProgram.nglDeleteProgramsNV(programs.remaining(), MemoryUtil.getAddress(programs), l);
    }

    static native void nglDeleteProgramsNV(int var0, long var1, long var3);

    public static void glDeleteProgramsNV(int program) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glDeleteProgramsNV;
        BufferChecks.checkFunctionAddress(l);
        NVProgram.nglDeleteProgramsNV(1, APIUtil.getInt(contextCapabilities, program), l);
    }

    public static void glGenProgramsNV(IntBuffer programs) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glGenProgramsNV;
        BufferChecks.checkFunctionAddress(l);
        BufferChecks.checkDirect(programs);
        NVProgram.nglGenProgramsNV(programs.remaining(), MemoryUtil.getAddress(programs), l);
    }

    static native void nglGenProgramsNV(int var0, long var1, long var3);

    public static int glGenProgramsNV() {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glGenProgramsNV;
        BufferChecks.checkFunctionAddress(l);
        IntBuffer intBuffer = APIUtil.getBufferInt(contextCapabilities);
        NVProgram.nglGenProgramsNV(1, MemoryUtil.getAddress(intBuffer), l);
        return intBuffer.get(0);
    }

    public static void glGetProgramNV(int programID, int parameterName, IntBuffer params) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glGetProgramivNV;
        BufferChecks.checkFunctionAddress(l);
        BufferChecks.checkDirect(params);
        NVProgram.nglGetProgramivNV(programID, parameterName, MemoryUtil.getAddress(params), l);
    }

    static native void nglGetProgramivNV(int var0, int var1, long var2, long var4);

    @Deprecated
    public static int glGetProgramNV(int programID, int parameterName) {
        return NVProgram.glGetProgramiNV(programID, parameterName);
    }

    public static int glGetProgramiNV(int programID, int parameterName) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glGetProgramivNV;
        BufferChecks.checkFunctionAddress(l);
        IntBuffer intBuffer = APIUtil.getBufferInt(contextCapabilities);
        NVProgram.nglGetProgramivNV(programID, parameterName, MemoryUtil.getAddress(intBuffer), l);
        return intBuffer.get(0);
    }

    public static void glGetProgramStringNV(int programID, int parameterName, ByteBuffer paramString) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glGetProgramStringNV;
        BufferChecks.checkFunctionAddress(l);
        BufferChecks.checkDirect(paramString);
        NVProgram.nglGetProgramStringNV(programID, parameterName, MemoryUtil.getAddress(paramString), l);
    }

    static native void nglGetProgramStringNV(int var0, int var1, long var2, long var4);

    public static String glGetProgramStringNV(int programID, int parameterName) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glGetProgramStringNV;
        BufferChecks.checkFunctionAddress(l);
        int n = NVProgram.glGetProgramiNV(programID, 34343);
        ByteBuffer byteBuffer = APIUtil.getBufferByte(contextCapabilities, n);
        NVProgram.nglGetProgramStringNV(programID, parameterName, MemoryUtil.getAddress(byteBuffer), l);
        byteBuffer.limit(n);
        return APIUtil.getString(contextCapabilities, byteBuffer);
    }

    public static boolean glIsProgramNV(int programID) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glIsProgramNV;
        BufferChecks.checkFunctionAddress(l);
        boolean bl = NVProgram.nglIsProgramNV(programID, l);
        return bl;
    }

    static native boolean nglIsProgramNV(int var0, long var1);

    public static boolean glAreProgramsResidentNV(IntBuffer programIDs, ByteBuffer programResidences) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glAreProgramsResidentNV;
        BufferChecks.checkFunctionAddress(l);
        BufferChecks.checkDirect(programIDs);
        BufferChecks.checkBuffer(programResidences, programIDs.remaining());
        boolean bl = NVProgram.nglAreProgramsResidentNV(programIDs.remaining(), MemoryUtil.getAddress(programIDs), MemoryUtil.getAddress(programResidences), l);
        return bl;
    }

    static native boolean nglAreProgramsResidentNV(int var0, long var1, long var3, long var5);

    public static void glRequestResidentProgramsNV(IntBuffer programIDs) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glRequestResidentProgramsNV;
        BufferChecks.checkFunctionAddress(l);
        BufferChecks.checkDirect(programIDs);
        NVProgram.nglRequestResidentProgramsNV(programIDs.remaining(), MemoryUtil.getAddress(programIDs), l);
    }

    static native void nglRequestResidentProgramsNV(int var0, long var1, long var3);

    public static void glRequestResidentProgramsNV(int programID) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glRequestResidentProgramsNV;
        BufferChecks.checkFunctionAddress(l);
        NVProgram.nglRequestResidentProgramsNV(1, APIUtil.getInt(contextCapabilities, programID), l);
    }
}

