/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opengl;

import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import org.lwjgl.BufferChecks;
import org.lwjgl.MemoryUtil;
import org.lwjgl.opengl.APIUtil;
import org.lwjgl.opengl.ContextCapabilities;
import org.lwjgl.opengl.GLContext;

public final class NVTransformFeedback {
    public static final int GL_TRANSFORM_FEEDBACK_BUFFER_NV = 35982;
    public static final int GL_TRANSFORM_FEEDBACK_BUFFER_START_NV = 35972;
    public static final int GL_TRANSFORM_FEEDBACK_BUFFER_SIZE_NV = 35973;
    public static final int GL_TRANSFORM_FEEDBACK_RECORD_NV = 35974;
    public static final int GL_TRANSFORM_FEEDBACK_BUFFER_BINDING_NV = 35983;
    public static final int GL_INTERLEAVED_ATTRIBS_NV = 35980;
    public static final int GL_SEPARATE_ATTRIBS_NV = 35981;
    public static final int GL_PRIMITIVES_GENERATED_NV = 35975;
    public static final int GL_TRANSFORM_FEEDBACK_PRIMITIVES_WRITTEN_NV = 35976;
    public static final int GL_RASTERIZER_DISCARD_NV = 35977;
    public static final int GL_MAX_TRANSFORM_FEEDBACK_INTERLEAVED_COMPONENTS_NV = 35978;
    public static final int GL_MAX_TRANSFORM_FEEDBACK_SEPARATE_ATTRIBS_NV = 35979;
    public static final int GL_MAX_TRANSFORM_FEEDBACK_SEPARATE_COMPONENTS_NV = 35968;
    public static final int GL_TRANSFORM_FEEDBACK_ATTRIBS_NV = 35966;
    public static final int GL_ACTIVE_VARYINGS_NV = 35969;
    public static final int GL_ACTIVE_VARYING_MAX_LENGTH_NV = 35970;
    public static final int GL_TRANSFORM_FEEDBACK_VARYINGS_NV = 35971;
    public static final int GL_TRANSFORM_FEEDBACK_BUFFER_MODE_NV = 35967;
    public static final int GL_BACK_PRIMARY_COLOR_NV = 35959;
    public static final int GL_BACK_SECONDARY_COLOR_NV = 35960;
    public static final int GL_TEXTURE_COORD_NV = 35961;
    public static final int GL_CLIP_DISTANCE_NV = 35962;
    public static final int GL_VERTEX_ID_NV = 35963;
    public static final int GL_PRIMITIVE_ID_NV = 35964;
    public static final int GL_GENERIC_ATTRIB_NV = 35965;
    public static final int GL_LAYER_NV = 36266;

    private NVTransformFeedback() {
    }

    public static void glBindBufferRangeNV(int target, int index, int buffer, long offset, long size) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glBindBufferRangeNV;
        BufferChecks.checkFunctionAddress(l);
        NVTransformFeedback.nglBindBufferRangeNV(target, index, buffer, offset, size, l);
    }

    static native void nglBindBufferRangeNV(int var0, int var1, int var2, long var3, long var5, long var7);

    public static void glBindBufferOffsetNV(int target, int index, int buffer, long offset) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glBindBufferOffsetNV;
        BufferChecks.checkFunctionAddress(l);
        NVTransformFeedback.nglBindBufferOffsetNV(target, index, buffer, offset, l);
    }

    static native void nglBindBufferOffsetNV(int var0, int var1, int var2, long var3, long var5);

    public static void glBindBufferBaseNV(int target, int index, int buffer) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glBindBufferBaseNV;
        BufferChecks.checkFunctionAddress(l);
        NVTransformFeedback.nglBindBufferBaseNV(target, index, buffer, l);
    }

    static native void nglBindBufferBaseNV(int var0, int var1, int var2, long var3);

    public static void glTransformFeedbackAttribsNV(IntBuffer attribs, int bufferMode) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glTransformFeedbackAttribsNV;
        BufferChecks.checkFunctionAddress(l);
        BufferChecks.checkBuffer(attribs, 3);
        NVTransformFeedback.nglTransformFeedbackAttribsNV(attribs.remaining() / 3, MemoryUtil.getAddress(attribs), bufferMode, l);
    }

    static native void nglTransformFeedbackAttribsNV(int var0, long var1, int var3, long var4);

    public static void glTransformFeedbackVaryingsNV(int program, IntBuffer locations, int bufferMode) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glTransformFeedbackVaryingsNV;
        BufferChecks.checkFunctionAddress(l);
        BufferChecks.checkDirect(locations);
        NVTransformFeedback.nglTransformFeedbackVaryingsNV(program, locations.remaining(), MemoryUtil.getAddress(locations), bufferMode, l);
    }

    static native void nglTransformFeedbackVaryingsNV(int var0, int var1, long var2, int var4, long var5);

    public static void glBeginTransformFeedbackNV(int primitiveMode) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glBeginTransformFeedbackNV;
        BufferChecks.checkFunctionAddress(l);
        NVTransformFeedback.nglBeginTransformFeedbackNV(primitiveMode, l);
    }

    static native void nglBeginTransformFeedbackNV(int var0, long var1);

    public static void glEndTransformFeedbackNV() {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glEndTransformFeedbackNV;
        BufferChecks.checkFunctionAddress(l);
        NVTransformFeedback.nglEndTransformFeedbackNV(l);
    }

    static native void nglEndTransformFeedbackNV(long var0);

    public static int glGetVaryingLocationNV(int program, ByteBuffer name) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glGetVaryingLocationNV;
        BufferChecks.checkFunctionAddress(l);
        BufferChecks.checkDirect(name);
        BufferChecks.checkNullTerminated(name);
        int n = NVTransformFeedback.nglGetVaryingLocationNV(program, MemoryUtil.getAddress(name), l);
        return n;
    }

    static native int nglGetVaryingLocationNV(int var0, long var1, long var3);

    public static int glGetVaryingLocationNV(int program, CharSequence name) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glGetVaryingLocationNV;
        BufferChecks.checkFunctionAddress(l);
        int n = NVTransformFeedback.nglGetVaryingLocationNV(program, APIUtil.getBufferNT(contextCapabilities, name), l);
        return n;
    }

    public static void glGetActiveVaryingNV(int program, int index, IntBuffer length, IntBuffer size, IntBuffer type, ByteBuffer name) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glGetActiveVaryingNV;
        BufferChecks.checkFunctionAddress(l);
        if (length != null) {
            BufferChecks.checkBuffer(length, 1);
        }
        BufferChecks.checkBuffer(size, 1);
        BufferChecks.checkBuffer(type, 1);
        BufferChecks.checkDirect(name);
        NVTransformFeedback.nglGetActiveVaryingNV(program, index, name.remaining(), MemoryUtil.getAddressSafe(length), MemoryUtil.getAddress(size), MemoryUtil.getAddress(type), MemoryUtil.getAddress(name), l);
    }

    static native void nglGetActiveVaryingNV(int var0, int var1, int var2, long var3, long var5, long var7, long var9, long var11);

    public static String glGetActiveVaryingNV(int program, int index, int bufSize, IntBuffer sizeType) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glGetActiveVaryingNV;
        BufferChecks.checkFunctionAddress(l);
        BufferChecks.checkBuffer(sizeType, 2);
        IntBuffer intBuffer = APIUtil.getLengths(contextCapabilities);
        ByteBuffer byteBuffer = APIUtil.getBufferByte(contextCapabilities, bufSize);
        NVTransformFeedback.nglGetActiveVaryingNV(program, index, bufSize, MemoryUtil.getAddress0(intBuffer), MemoryUtil.getAddress(sizeType), MemoryUtil.getAddress(sizeType, sizeType.position() + 1), MemoryUtil.getAddress(byteBuffer), l);
        byteBuffer.limit(intBuffer.get(0));
        return APIUtil.getString(contextCapabilities, byteBuffer);
    }

    public static String glGetActiveVaryingNV(int program, int index, int bufSize) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glGetActiveVaryingNV;
        BufferChecks.checkFunctionAddress(l);
        IntBuffer intBuffer = APIUtil.getLengths(contextCapabilities);
        ByteBuffer byteBuffer = APIUtil.getBufferByte(contextCapabilities, bufSize);
        NVTransformFeedback.nglGetActiveVaryingNV(program, index, bufSize, MemoryUtil.getAddress0(intBuffer), MemoryUtil.getAddress0(APIUtil.getBufferInt(contextCapabilities)), MemoryUtil.getAddress(APIUtil.getBufferInt(contextCapabilities), 1), MemoryUtil.getAddress(byteBuffer), l);
        byteBuffer.limit(intBuffer.get(0));
        return APIUtil.getString(contextCapabilities, byteBuffer);
    }

    public static int glGetActiveVaryingSizeNV(int program, int index) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glGetActiveVaryingNV;
        BufferChecks.checkFunctionAddress(l);
        IntBuffer intBuffer = APIUtil.getBufferInt(contextCapabilities);
        NVTransformFeedback.nglGetActiveVaryingNV(program, index, 0, 0L, MemoryUtil.getAddress(intBuffer), MemoryUtil.getAddress(intBuffer, 1), APIUtil.getBufferByte0(contextCapabilities), l);
        return intBuffer.get(0);
    }

    public static int glGetActiveVaryingTypeNV(int program, int index) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glGetActiveVaryingNV;
        BufferChecks.checkFunctionAddress(l);
        IntBuffer intBuffer = APIUtil.getBufferInt(contextCapabilities);
        NVTransformFeedback.nglGetActiveVaryingNV(program, index, 0, 0L, MemoryUtil.getAddress(intBuffer, 1), MemoryUtil.getAddress(intBuffer), APIUtil.getBufferByte0(contextCapabilities), l);
        return intBuffer.get(0);
    }

    public static void glActiveVaryingNV(int program, ByteBuffer name) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glActiveVaryingNV;
        BufferChecks.checkFunctionAddress(l);
        BufferChecks.checkDirect(name);
        BufferChecks.checkNullTerminated(name);
        NVTransformFeedback.nglActiveVaryingNV(program, MemoryUtil.getAddress(name), l);
    }

    static native void nglActiveVaryingNV(int var0, long var1, long var3);

    public static void glActiveVaryingNV(int program, CharSequence name) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glActiveVaryingNV;
        BufferChecks.checkFunctionAddress(l);
        NVTransformFeedback.nglActiveVaryingNV(program, APIUtil.getBufferNT(contextCapabilities, name), l);
    }

    public static void glGetTransformFeedbackVaryingNV(int program, int index, IntBuffer location) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glGetTransformFeedbackVaryingNV;
        BufferChecks.checkFunctionAddress(l);
        BufferChecks.checkBuffer(location, 1);
        NVTransformFeedback.nglGetTransformFeedbackVaryingNV(program, index, MemoryUtil.getAddress(location), l);
    }

    static native void nglGetTransformFeedbackVaryingNV(int var0, int var1, long var2, long var4);

    public static int glGetTransformFeedbackVaryingNV(int program, int index) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l = contextCapabilities.glGetTransformFeedbackVaryingNV;
        BufferChecks.checkFunctionAddress(l);
        IntBuffer intBuffer = APIUtil.getBufferInt(contextCapabilities);
        NVTransformFeedback.nglGetTransformFeedbackVaryingNV(program, index, MemoryUtil.getAddress(intBuffer), l);
        return intBuffer.get(0);
    }
}

