#version 330 core

// Указываем атрибуты по индексам, соответствующим порядку в setAttributes()
layout (location = 0) in vec3 aPos;               // Позиция (3 компоненты)
layout (location = 1) in vec2 aTexCoord;           // Текстурные координаты (2 компоненты)
layout (location = 2) in vec4 aColor;              // Цвет (4 компоненты)
layout (location = 3) in vec2 aBTexCoord;          // Координаты яркости (2 компоненты)
layout (location = 10) in vec3 aEntityData;        // Данные сущности (3 компоненты)
layout (location = 4) in vec3 aNormal;             // Нормаль (3 компоненты)
layout (location = 12) in vec4 aTangent;           // Тангенты (4 компоненты)
layout (location = 11) in vec2 aMidTexCoord;       // Текстура (2 компоненты)

uniform mat4 modelView;
uniform mat4 proj;
uniform mat4 projInv;
uniform vec4 viewport;
uniform vec4 fogColor;
uniform vec2 fogStartEnd;
uniform int fogMode;
uniform float fogDensity;
uniform vec3 renderOffset;

out vec2 TexCoord;
out vec2 BTexCoord;
out vec4 Color;
out vec4 Viewport;
out mat4 ProjInv;
out vec4 FogColor;
out vec2 FogStartEnd;
out float FogFactor; // -1 means: disable fog

// Новые данные, передаем для дальнейшей обработки
out vec3 EntityData;     // Данные сущности
out vec3 Normal;         // Нормаль
out vec4 Tangent;        // Тангенты
out vec2 MidTexCoord;    // Текстура

void main()
{
	vec4 untransformedPos = (vec4(aPos, 1.0) + vec4(renderOffset.x, renderOffset.y + 0.12, renderOffset.z, 0));
	gl_Position = proj * modelView * untransformedPos;

	TexCoord = aTexCoord;
	BTexCoord = aBTexCoord;
	Color = aColor;
	Viewport = viewport;
	ProjInv = projInv;
	FogColor = fogColor;

	// Применяем данные нормалей, тангента и entityData
	Normal = aNormal;
	Tangent = aTangent;
	EntityData = aEntityData;

	if (fogStartEnd.x >= 0 && fogStartEnd.y >= 0) {
		float s = fogStartEnd.x;
		float e = fogStartEnd.y;
		float c = length(untransformedPos);

		float fogFactor = fogMode == 0x2601
		? clamp((e - c) / (e - s), 0, 1) /* GL_LINEAR */
		: exp(-fogDensity * c); /* GL_EXP */

		FogFactor = fogFactor;
	} else {
		FogFactor = -1;
	}
	FogStartEnd = fogStartEnd;
}
